/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.world.gen;

import com.stal111.forbidden_arcanus.world.feature.WorldGenCherrywoodTree;
import com.stal111.forbidden_arcanus.world.feature.WorldGenEdelwoodLog;
import com.stal111.forbidden_arcanus.world.feature.WorldGenMysterywoodTree;
import com.stal111.forbidden_arcanus.world.feature.WorldGenYellowOrchid;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    public WorldGenerator EDELWOOD = new WorldGenEdelwoodLog();
    public WorldGenerator CHERRYWOOD_TREE = new WorldGenCherrywoodTree(true);
    public WorldGenerator MYSTERYWOOD_TREE = new WorldGenMysterywoodTree(true);
    public WorldGenerator YELLOW_ORCHID = new WorldGenYellowOrchid();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world) {
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
            this.addPlantSpawn(this.EDELWOOD, world, random, chunkX * 16 + 8, chunkZ * 16 + 8, 3, 50, 100);
            this.addPlantSpawn(this.CHERRYWOOD_TREE, world, random, chunkX * 16 + 8, chunkZ * 16 + 8, 2, 50, 100);
            this.addPlantSpawn(this.MYSTERYWOOD_TREE, world, random, chunkX * 16 + 8, chunkZ * 16 + 8, 2, 50, 100);
            this.addPlantSpawn(this.YELLOW_ORCHID, world, random, chunkX * 16 + 8, chunkZ * 16 + 8, 3, 50, 100);
        }
    }

    public void addPlantSpawn(WorldGenerator generator, World world, Random random, int blockXPos, int blockZPos, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY + 1);
            int posZ = blockZPos + random.nextInt(16);
            if (generator == this.EDELWOOD && world.func_180494_b(new BlockPos(posX, posY, posZ)) != Biomes.field_150585_R) {
                return;
            }
            if (generator == this.CHERRYWOOD_TREE && world.func_180494_b(new BlockPos(posX, posY, posZ)) != Biomes.field_76772_c) {
                return;
            }
            if (generator == this.MYSTERYWOOD_TREE && world.func_180494_b(new BlockPos(posX, posY, posZ)) != Biomes.field_185444_T) {
                return;
            }
            if (generator == this.YELLOW_ORCHID && world.func_180494_b(new BlockPos(posX, posY, posZ)) != Biomes.field_185444_T) {
                return;
            }
            generator.func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

