/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntityAxeAttack;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoMask;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemWroughtAxe;
import com.bobmowzie.mowziesmobs.server.item.ItemWroughtHelm;
import com.bobmowzie.mowziesmobs.server.potion.PotionHandler;
import com.bobmowzie.mowziesmobs.server.property.MowzieLivingProperties;
import com.bobmowzie.mowziesmobs.server.property.MowziePlayerProperties;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.event.PlayerModelEvent;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private static final ResourceLocation MARIO;
    private static final ResourceLocation FROZEN_BLUR;
    long startWroughtnautHitTime;
    long lastWroughtnautHitTime;

    @SubscribeEvent
    public void onFrameRender(RenderItemInFrameEvent event) {
        if (event.getItem().func_77973_b() instanceof ItemWroughtAxe) {
            GlStateManager.func_179109_b((float)0.325f, (float)0.4f, (float)-0.05f);
            GlStateManager.func_179152_a((float)-0.65f, (float)-0.65f, (float)0.65f);
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)45.0f, (float)-1.0f, (float)0.0f, (float)-1.0f);
        } else if (event.getItem().func_77973_b() instanceof ItemWroughtHelm) {
            GlStateManager.func_179109_b((float)0.19f, (float)-0.37f, (float)-0.25f);
        } else if (event.getItem().func_77973_b() instanceof ItemBarakoaMask) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.1f);
        } else if (event.getItem().func_77973_b() instanceof ItemBarakoMask) {
            GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
            GlStateManager.func_179109_b((float)0.32f, (float)-0.4f, (float)-0.25f);
        }
    }

    @SubscribeEvent
    public void onHandRender(RenderSpecificHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        MowziePlayerProperties propertyPlayer = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        if (event.getHand() == EnumHand.MAIN_HAND && propertyPlayer != null && propertyPlayer.untilAxeSwing > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPre(PlayerModelEvent.SetRotationAngles event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ModelBiped model = event.getModel();
        player.func_184586_b(EnumHand.MAIN_HAND);
        MowziePlayerProperties propertyPlayer = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
        float delta = LLibrary.PROXY.getPartialTicks();
        if (propertyPlayer != null && propertyPlayer.geomancy.tunneling) {
            model.field_78117_n = false;
            Vec3d moveVec = new Vec3d(player.field_70159_w, player.field_70181_x, player.field_70179_y);
            moveVec = moveVec.func_72432_b();
            GlStateManager.func_179114_b((float)(45.0f - 45.0f * (float)moveVec.field_72448_b), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (propertyPlayer != null && propertyPlayer.untilAxeSwing > 0) {
            float frame = (float)(30 - propertyPlayer.untilAxeSwing) + delta;
            ModelRenderer arm = model.field_178723_h;
            if (propertyPlayer.verticalSwing) {
                float swingArc = 3.0f;
                arm.field_78795_f = -2.7f + (float)((double)(swingArc * 1.0f) / (1.0 + Math.exp(1.3f * (-frame + (float)EntityAxeAttack.SWING_DURATION_HOR / 2.0f))));
                arm.field_78795_f = Math.min(arm.field_78795_f, -0.1f);
                if (!model.field_78117_n) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.3f, (float)0.0f);
                }
                model.field_78117_n = true;
            } else {
                float swingArc = 2.5f;
                arm.field_78795_f = -1.75f + (float)((double)(swingArc * 1.0f) / (1.0 + Math.exp(1.3f * (-frame + (float)EntityAxeAttack.SWING_DURATION_HOR / 2.0f))));
                arm.field_78808_h = 1.5f;
            }
        }
    }

    private void toDefaultBiped(ModelBiped model) {
        model.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        model.field_78116_c.field_78795_f = 0.0f;
        model.field_78116_c.field_78796_g = 0.0f;
        model.field_78116_c.field_78808_h = 0.0f;
        model.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        model.field_178720_f.field_78795_f = 0.0f;
        model.field_178720_f.field_78796_g = 0.0f;
        model.field_178720_f.field_78808_h = 0.0f;
        model.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        model.field_78115_e.field_78795_f = 0.0f;
        model.field_78115_e.field_78796_g = 0.0f;
        model.field_78115_e.field_78808_h = 0.0f;
        model.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        model.field_178723_h.field_78795_f = 0.0f;
        model.field_178723_h.field_78796_g = 0.0f;
        model.field_178723_h.field_78808_h = 0.0f;
        model.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        model.field_178724_i.field_78795_f = 0.0f;
        model.field_178724_i.field_78796_g = 0.0f;
        model.field_178724_i.field_78808_h = 0.0f;
        model.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
        model.field_178721_j.field_78795_f = 0.0f;
        model.field_178721_j.field_78796_g = 0.0f;
        model.field_178721_j.field_78808_h = 0.0f;
        model.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        model.field_178722_k.field_78795_f = 0.0f;
        model.field_178722_k.field_78796_g = 0.0f;
        model.field_178722_k.field_78808_h = 0.0f;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            MowziePlayerProperties propertyPlayer = (MowziePlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowziePlayerProperties.class);
            if (propertyPlayer != null && propertyPlayer.geomancy.canUse((EntityPlayer)player) && propertyPlayer.geomancy.isSpawningBoulder() && propertyPlayer.geomancy.getSpawnBoulderCharge() > 2) {
                Vec3d lookPos = propertyPlayer.geomancy.getLookPos();
                Vec3d playerEyes = player.func_174824_e(LLibrary.PROXY.getPartialTicks());
                Vec3d vec = playerEyes.func_178788_d(lookPos).func_72432_b();
                float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
                float pitch = (float)Math.asin(vec.field_72448_b);
                float dYaw = ((float)((double)(yaw * 180.0f) / Math.PI + 90.0) - player.field_70177_z) / 2.0f;
                float dPitch = ((float)((double)(pitch * 180.0f) / Math.PI) - player.field_70125_A) / 2.0f;
                player.field_70177_z += dYaw;
                player.field_70125_A += dPitch;
                ClientEventHandler.stopMouseMove();
            }
            MowzieLivingProperties propertyLiving = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MowzieLivingProperties.class);
            if (player.func_70644_a((Potion)PotionHandler.FROZEN) && propertyLiving.prevFrozen) {
                ClientEventHandler.stopMouseMove();
            }
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.getEntity();
        MowzieLivingProperties property = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, MowzieLivingProperties.class);
        if (entity.func_70644_a((Potion)PotionHandler.FROZEN) && property.prevFrozen) {
            entity.field_70177_z = entity.field_70126_B = property.frozenYaw;
            entity.field_70125_A = entity.field_70127_C = property.frozenPitch;
            entity.field_70759_as = entity.field_70758_at = property.frozenYawHead;
            entity.field_70761_aq = entity.field_70760_ar = property.frozenRenderYawOffset;
            entity.field_70733_aJ = entity.field_70732_aI = property.frozenSwingProgress;
            entity.field_70721_aZ = entity.field_184618_aE = property.frozenLimbSwingAmount;
            entity.func_70095_a(false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post e) {
        int startTime = 210;
        int pointStart = 1200;
        int timePerMillis = 22;
        if (e.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            long now = System.currentTimeMillis();
            if (now - this.lastWroughtnautHitTime < 500L) {
                int t = (int)(now - this.startWroughtnautHitTime);
                int progress = t / 22;
                int time = 210 - progress;
                if (time < 0) {
                    this.startWroughtnautHitTime = now;
                    progress = 0;
                    time = 210;
                }
                int points = 1200 + progress * 50;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MARIO);
                ScaledResolution res = e.getResolution();
                int offsetY = 16;
                int col = res.func_78326_a() / 4;
                int marioOffsetX = col / 2 - 18;
                Gui.func_146110_a((int)marioOffsetX, (int)offsetY, (float)0.0f, (float)16.0f, (int)39, (int)7, (float)64.0f, (float)64.0f);
                ClientEventHandler.drawMarioNumber(marioOffsetX, offsetY + 8, points, 6);
                int coinOffsetX = col + col / 2 - 15;
                int coinU = 40 + (int)(Math.max(0.0f, MathHelper.func_76126_a((float)((float)t * 0.005f))) * 2.0f + 0.5f) * 6;
                Gui.func_146110_a((int)coinOffsetX, (int)(offsetY + 8), (float)coinU, (float)8.0f, (int)5, (int)8, (float)64.0f, (float)64.0f);
                Gui.func_146110_a((int)(coinOffsetX + 9), (int)(offsetY + 8), (float)16.0f, (float)8.0f, (int)23, (int)7, (float)64.0f, (float)64.0f);
                Gui.func_146110_a((int)(col * 2 + col / 2 - 19), (int)offsetY, (float)0.0f, (float)24.0f, (int)39, (int)15, (float)64.0f, (float)64.0f);
                int timeOffsetX = col * 3 + col / 2 - 15;
                Gui.func_146110_a((int)timeOffsetX, (int)offsetY, (float)0.0f, (float)40.0f, (int)30, (int)7, (float)64.0f, (float)64.0f);
                ClientEventHandler.drawMarioNumber(timeOffsetX + 8, offsetY + 8, time, 3);
            }
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)PotionHandler.FROZEN) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(FROZEN_BLUR);
                ScaledResolution res = e.getResolution();
                Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)res.func_78326_a(), (int)res.func_78328_b(), (float)res.func_78326_a(), (float)res.func_78328_b());
            }
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent.Pre event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184218_aH() && player.func_184187_bx() instanceof EntityFrozenController) {
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
                event.setCanceled(true);
            }
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
                Minecraft.func_71410_x().field_71456_v.func_110326_a("", false);
            }
        }
    }

    private static void drawMarioNumber(int x, int y, int value, int length) {
        int n = 0;
        while (n < length) {
            int digit = value % 10;
            Gui.func_146110_a((int)(x + 8 * (length - n - 1)), (int)y, (float)(digit * 8 % 64), (float)(digit / 8 * 8), (int)8, (int)7, (float)64.0f, (float)64.0f);
            ++n;
            value /= 10;
        }
    }

    public static void stopMouseMove() {
        Mouse.getDX();
        Mouse.getDY();
        Minecraft.func_71410_x().field_71417_B.field_74375_b = 0;
        Minecraft.func_71410_x().field_71417_B.field_74377_a = 0;
    }

    static {
        MARIO = new ResourceLocation("mowziesmobs", "textures/gui/mario.png");
        FROZEN_BLUR = new ResourceLocation("mowziesmobs", "textures/gui/frozenblur.png");
    }
}

