/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uniquebase.api.IToggleEnchantment;

public abstract class BaseUEMod {
    static final List<BaseUEMod> MODS = new ObjectArrayList();
    public final List<Enchantment> enchantments = new ObjectArrayList();
    private Configuration config;
    String modName;

    public BaseUEMod() {
        MODS.add(this);
    }

    public static boolean containsMod(BaseUEMod mod) {
        return MODS.contains(mod);
    }

    public Enchantment register(Enchantment ench) {
        this.enchantments.add(ench);
        return ench;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void init(String modName, File file) {
        this.modName = modName;
        this.config = new Configuration(file);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addEnchantments();
        for (int i = 0; i < this.enchantments.size(); ++i) {
            Enchantment ench = this.enchantments.get(i);
            ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)ench);
            if (!(ench instanceof IToggleEnchantment)) continue;
            ((IToggleEnchantment)ench).loadIncompats();
        }
        this.loadConfig();
        ModContainer baseContainer = (ModContainer)Loader.instance().getIndexedModList().get("uniquebase");
        ModContainer current = Loader.instance().activeModContainer();
        baseContainer.getMetadata().childMods.add(current);
        current.getMetadata().parentMod = baseContainer;
    }

    protected abstract void addEnchantments();

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equalsIgnoreCase(this.modName)) {
            return;
        }
        try {
            for (Enchantment ench : this.enchantments) {
                if (!(ench instanceof IToggleEnchantment)) continue;
                ((IToggleEnchantment)ench).loadFromConfig(this.config);
            }
            this.config.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadConfig() {
        try {
            this.config.load();
            for (Enchantment ench : this.enchantments) {
                if (!(ench instanceof IToggleEnchantment)) continue;
                ((IToggleEnchantment)ench).loadFromConfig(this.config);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.config.save();
        }
    }

    public static void reload() {
        for (BaseUEMod mod : MODS) {
            mod.loadConfig();
        }
    }

    public static List<BaseUEMod> getMods() {
        return Collections.unmodifiableList(MODS);
    }
}

