/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import uniquebase.api.IToggleEnchantment;
import uniquebase.utils.IStat;
import uniquebase.utils.IdStat;

public abstract class UniqueEnchantment
extends Enchantment
implements IToggleEnchantment {
    public static final Enchantment.Rarity[] RARITIES = Enchantment.Rarity.values();
    DefaultData defaults;
    DefaultData actualData;
    List<IStat> stats = new ObjectArrayList();
    protected boolean enabled = false;
    protected boolean activated = false;
    protected boolean isCurse = false;
    protected boolean disableDefaultItems = false;
    String configName;
    String categoryName = "base";

    protected UniqueEnchantment(DefaultData data, EnumEnchantmentType typeIn, EntityEquipmentSlot ... slots) {
        super(data.getRarity(), typeIn, slots);
        this.func_77322_b(Loader.instance().activeModContainer().getModId() + "." + data.getName());
        this.setRegistryName(data.getName());
        this.configName = data.getName();
        this.defaults = data;
        this.actualData = data;
    }

    public void addStats(IStat ... stats) {
        this.stats.addAll((Collection<IStat>)ObjectArrayList.wrap((Object[])stats));
    }

    public UniqueEnchantment setCurse() {
        this.isCurse = true;
        return this;
    }

    public UniqueEnchantment setDisableDefaultItems() {
        this.disableDefaultItems = true;
        return this;
    }

    public boolean func_190936_d() {
        return this.isCurse;
    }

    public int func_77319_d() {
        return this.actualData.getMinLevel();
    }

    public int func_77325_b() {
        return this.actualData.getMaxLevel();
    }

    public boolean func_185261_e() {
        return this.actualData.isTreasure();
    }

    public int func_77321_a(int enchantmentLevel) {
        return this.actualData.getLevelCost(enchantmentLevel);
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + this.actualData.getRangeCost();
    }

    public Enchantment.Rarity func_77324_c() {
        return this.actualData.getRarity();
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && !this.actualData.incompats.contains(ench.getRegistryName());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.enabled ? (!this.disableDefaultItems && super.canApplyAtEnchantingTable(stack) || this.canApplyToItem(stack) || this.actualData.isCompatible(stack)) && !this.canNotApplyToItems(stack) && !this.actualData.isIncompatible(stack) : false;
    }

    public boolean isAllowedOnBooks() {
        return this.enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.activated;
    }

    @Override
    public int getHardCap() {
        return this.actualData.getHardCap();
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return false;
    }

    protected boolean canNotApplyToItems(ItemStack stack) {
        return false;
    }

    @Override
    public String getConfigName() {
        return this.categoryName + "." + this.configName;
    }

    protected void setCategory(String name) {
        this.categoryName = name;
    }

    protected void addIncompats(Enchantment ... enchantments) {
        this.defaults.addIncompats(enchantments);
    }

    public void addIncompats(ResourceLocation ... locations) {
        this.defaults.addIncompats(locations);
    }

    @Override
    public void loadIncompats() {
    }

    @Override
    public final void loadFromConfig(Configuration config) {
        this.enabled = config.get(this.getConfigName(), "enabled", true, "If the Enchantment is Obtainable").getBoolean();
        this.activated = config.get(this.getConfigName(), "activated", true, "If the Enchantment has any effect").getBoolean();
        this.actualData = new DefaultData(this.defaults, config, this.getConfigName());
        int m = this.stats.size();
        for (int i = 0; i < m; ++i) {
            this.stats.get(i).handleConfig(config, this.getConfigName());
        }
        this.loadData(config);
        config.getCategory(this.getConfigName()).setLanguageKey(this.func_77320_a());
    }

    public void loadData(Configuration config) {
    }

    public static class DefaultData {
        String name;
        Enchantment.Rarity rare;
        int minLevel;
        int maxLevel;
        boolean isTreasure;
        int baseCost;
        int levelCost;
        int rangeCost;
        int hardCap;
        Set<ResourceLocation> incompats = new ObjectOpenHashSet();
        IdStat incompatibleItems = new IdStat("incompatible_items", "Allows to add custom incompatible Items", ForgeRegistries.ITEMS);
        IdStat compatibleItems = new IdStat("compatible_items", "Allows to add custom compatible Items", ForgeRegistries.ITEMS);

        public DefaultData(DefaultData defaultValues, Configuration config, String configName) {
            this.name = defaultValues.getName();
            this.minLevel = config.get(configName, "min_level", defaultValues.getMinLevel(), "Minimum Enchantment Level").getInt();
            this.maxLevel = config.get(configName, "max_level", defaultValues.getMaxLevel(), "Maximum Enchantment Level").getInt();
            this.rare = RARITIES[config.get(configName, "rarity", defaultValues.getRarity().ordinal(), "Rarity of the Enchantment").getInt()];
            this.isTreasure = config.get(configName, "treasure", defaultValues.isTreasure(), "If the Enchantment is a Treasure").getBoolean();
            this.baseCost = config.get(configName, "base_cost", defaultValues.getBaseCost(), "Minimum Level for Enchanting").getInt();
            this.levelCost = config.get(configName, "per_level_cost", defaultValues.getLevelCost(), "Increase of levels per Enchantment Level").getInt();
            this.rangeCost = config.get(configName, "cost_limit", defaultValues.getRangeCost(), "The Additional Upper Range of Required Levels").getInt();
            this.hardCap = config.get(configName, "hard_cap", defaultValues.getHardCap(), "Hard Limit of where the Enchantment will be capped even if the level is higher").getInt();
            String[] result = config.get(configName, "incompats", defaultValues.getInCompats(), "Enchantments that are not compatible with this Enchantment").getStringList();
            int m = result.length;
            for (int i = 0; i < m; ++i) {
                try {
                    this.incompats.add(new ResourceLocation(result[i]));
                    continue;
                }
                catch (Exception e) {
                    FMLLog.log.error("Adding Incompat [" + result[i] + "] has caused a crash", (Throwable)e);
                }
            }
            this.incompatibleItems.handleConfig(config, configName);
            this.compatibleItems.handleConfig(config, configName);
        }

        public DefaultData(String name, Enchantment.Rarity rare, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this(name, rare, 1, maxLevel, isTreasure, baseCost, levelCost, rangeCost);
        }

        public DefaultData(String name, Enchantment.Rarity rare, int minLevel, int maxLevel, boolean isTreasure, int baseCost, int levelCost, int rangeCost) {
            this.name = name;
            this.rare = rare;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.isTreasure = isTreasure;
            this.baseCost = baseCost;
            this.levelCost = levelCost;
            this.rangeCost = rangeCost;
            this.hardCap = 100;
        }

        public DefaultData setHardCap(int max) {
            this.hardCap = max;
            return this;
        }

        public void addIncompats(Enchantment ... enchantments) {
            int i = 0;
            int m = enchantments.length;
            while (i < m) {
                this.incompats.add(enchantments[i++].getRegistryName());
            }
        }

        public void addIncompats(ResourceLocation ... locations) {
            this.incompats.addAll((Collection<ResourceLocation>)ObjectArrayList.wrap((Object[])locations));
        }

        private String[] getInCompats() {
            String[] incompatString = new String[this.incompats.size()];
            int index = 0;
            for (ResourceLocation loc : this.incompats) {
                incompatString[index++] = loc.toString();
            }
            return incompatString;
        }

        public int getLevelCost(int minLevel) {
            return this.baseCost - this.levelCost + minLevel * this.levelCost;
        }

        public boolean isCompatible(ItemStack stack) {
            return this.compatibleItems.contains(stack.func_77973_b().getRegistryName());
        }

        public boolean isIncompatible(ItemStack stack) {
            return this.incompatibleItems.contains(stack.func_77973_b().getRegistryName());
        }

        public String getName() {
            return this.name;
        }

        public Enchantment.Rarity getRarity() {
            return this.rare;
        }

        public int getMinLevel() {
            return this.minLevel;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getHardCap() {
            return this.hardCap;
        }

        public boolean isTreasure() {
            return this.isTreasure;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public int getLevelCost() {
            return this.levelCost;
        }

        public int getRangeCost() {
            return this.rangeCost;
        }
    }
}

