/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;

public class EnchantmentContainer
extends Container {
    IInventory inventory;
    List<ItemStack> enchantments = new ObjectArrayList();

    public EnchantmentContainer(ItemStack stack) {
        int i;
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            ItemStack item = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a((ItemStack)item, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            EnchantmentContainer.addToolTip(item, TextFormatting.DARK_AQUA.toString() + I18n.func_135052_a((String)"unique.base.jei.max_level", (Object[])new Object[]{TextFormatting.WHITE.toString() + ((Enchantment)entry.getKey()).func_77325_b()}));
            EnchantmentContainer.addToolTip(item, TextFormatting.GOLD.toString() + I18n.func_135052_a((String)"unique.base.jei.treasure", (Object[])new Object[0]) + (((Enchantment)entry.getKey()).func_185261_e() ? TextFormatting.GREEN.toString() + "Yes" : TextFormatting.RED.toString() + "No"));
            EnchantmentContainer.addToolTip(item, TextFormatting.DARK_RED.toString() + I18n.func_135052_a((String)"unique.base.jei.curse", (Object[])new Object[0]) + (((Enchantment)entry.getKey()).func_190936_d() ? TextFormatting.RED.toString() + "Yes" : TextFormatting.GREEN.toString() + "No"));
            EnchantmentContainer.addToolTip(item, TextFormatting.DARK_PURPLE.toString() + I18n.func_135052_a((String)"unique.base.jei.rarity", (Object[])new Object[]{this.getFormatting(((Enchantment)entry.getKey()).func_77324_c()) + I18n.func_135052_a((String)("unique.base.jei." + ((Enchantment)entry.getKey()).func_77324_c().name().toLowerCase()), (Object[])new Object[0])}));
            this.enchantments.add(item);
        }
        this.inventory = new InventoryBasic("inv", false, this.enchantments.size() + 1);
        this.inventory.func_70299_a(0, stack);
        for (i = 0; i < this.enchantments.size(); ++i) {
            this.inventory.func_70299_a(i + 1, this.enchantments.get(i));
        }
        this.func_75146_a(new LockedSlot(this.inventory, 0, 16, 16));
        for (i = 0; i < this.enchantments.size(); ++i) {
            int x = i % 8;
            int y = i / 8;
            this.func_75146_a(new LockedSlot(this.inventory, i + 1, 17 + x * 18, 37 + y * 18));
        }
    }

    private TextFormatting getFormatting(Enchantment.Rarity rarity) {
        switch (rarity) {
            case COMMON: {
                return TextFormatting.WHITE;
            }
            case RARE: {
                return TextFormatting.AQUA;
            }
            case UNCOMMON: {
                return TextFormatting.YELLOW;
            }
            case VERY_RARE: {
                return TextFormatting.LIGHT_PURPLE;
            }
        }
        return TextFormatting.OBFUSCATED;
    }

    public static void addToolTip(ItemStack stack, String text) {
        NBTTagCompound nbt = stack.func_190925_c("display");
        NBTTagList list = nbt.func_150295_c("Lore", 8);
        list.func_74742_a((NBTBase)new NBTTagString(TextFormatting.RESET + text + TextFormatting.RESET));
        nbt.func_74782_a("Lore", (NBTBase)list);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public static class LockedSlot
    extends Slot {
        public LockedSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return false;
        }
    }
}

