/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.handler;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uniquebase.UniqueEnchantmentsBase;
import uniquebase.gui.EnchantmentGui;
import uniquebase.utils.MiscUtil;
import uniquebase.utils.StackUtils;
import uniquebase.utils.Triple;

public class BaseHandler {
    public static final BaseHandler INSTANCE = new BaseHandler();
    List<Tuple<Enchantment, String[]>> tooltips = new ObjectArrayList();
    List<Triple<Enchantment, ToIntFunction<ItemStack>, String>> anvilHelpers = new ObjectArrayList();
    int tooltipCounter;

    public void registerStorageTooltip(Enchantment ench, String translation, String tag) {
        this.tooltips.add((Tuple<Enchantment, String[]>)new Tuple((Object)ench, (Object)new String[]{translation, tag}));
    }

    public void registerAnvilHelper(Enchantment ench, ToIntFunction<ItemStack> helper, String tag) {
        this.anvilHelpers.add(Triple.create(ench, helper, tag));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        UniqueEnchantmentsBase.PROXY.update();
        if (UniqueEnchantmentsBase.ENCHANTMENT_GUI.test((EntityPlayer)mc.field_71439_g) && mc.field_71462_r instanceof GuiContainer && !(mc.field_71462_r instanceof EnchantmentGui)) {
            Slot slot = ((GuiContainer)mc.field_71462_r).getSlotUnderMouse();
            if (slot != null && slot.func_75216_d() && EnchantmentHelper.func_82781_a((ItemStack)slot.func_75211_c()).size() > 0) {
                ++this.tooltipCounter;
                if (this.tooltipCounter >= 40) {
                    mc.func_147108_a((GuiScreen)new EnchantmentGui(slot.func_75211_c().func_77946_l()));
                }
            } else {
                this.tooltipCounter = 0;
            }
        } else {
            this.tooltipCounter = 0;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTipEvent(ItemTooltipEvent event) {
        Slot slot;
        ItemStack stack = event.getItemStack();
        Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
        int m = this.tooltips.size();
        for (int i = 0; i < m; ++i) {
            Tuple<Enchantment, String[]> entry = this.tooltips.get(i);
            if (enchantments.getInt(entry.func_76341_a()) <= 0) continue;
            String[] names = (String[])entry.func_76340_b();
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)names[0], (Object[])new Object[]{StackUtils.getInt(stack, names[1], 0)}));
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiContainer && !(screen instanceof EnchantmentGui) && (slot = ((GuiContainer)screen).getSlotUnderMouse()) != null && slot.func_75216_d() && EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0) {
            if (this.tooltipCounter > 0) {
                int i;
                StringBuilder builder = new StringBuilder();
                for (i = 0; i < this.tooltipCounter; ++i) {
                    builder.append("|");
                }
                builder.append(TextFormatting.DARK_GRAY);
                while (i < 40) {
                    builder.append("|");
                    ++i;
                }
                event.getToolTip().add(1, builder.toString());
            } else {
                event.getToolTip().add(1, I18n.func_135052_a((String)"unique.base.jei.press_gui", (Object[])new Object[]{UniqueEnchantmentsBase.ENCHANTMENT_GUI.getKeyName()}));
            }
        }
    }

    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        if (event.getEntityPlayer().func_70093_af() && (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c() instanceof BlockAnvil) {
            ItemStack stack = event.getItemStack();
            Object2IntMap<Enchantment> enchantments = MiscUtil.getEnchantments(stack);
            int m = this.anvilHelpers.size();
            for (int i = 0; i < m; ++i) {
                int found;
                Triple<Enchantment, ToIntFunction<ItemStack>, String> entry = this.anvilHelpers.get(i);
                if (enchantments.getInt((Object)entry.getKey()) <= 0 || (found = StackUtils.consumeItems(event.getEntityPlayer(), entry.getValue(), Integer.MAX_VALUE)) <= 0) continue;
                StackUtils.setInt(stack, entry.getExtra(), found + StackUtils.getInt(stack, entry.getExtra(), 0));
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

