/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.handler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uniquebase.UniqueEnchantmentsBase;
import uniquebase.api.IKeyBind;
import uniquebase.handler.Proxy;
import uniquebase.networking.KeyPacket;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends Proxy {
    Map<String, ClientPlayerKey> keys = new Object2ObjectLinkedOpenHashMap();
    Object2BooleanMap<String> lastKeyState = Object2BooleanMaps.emptyMap();

    @Override
    public void update() {
        Object2BooleanOpenHashMap keyState = new Object2BooleanOpenHashMap();
        for (ClientPlayerKey key : this.keys.values()) {
            key.appendState((Object2BooleanMap<String>)keyState);
        }
        if (!this.lastKeyState.equals((Object)keyState)) {
            this.lastKeyState = keyState.isEmpty() ? Object2BooleanMaps.emptyMap() : keyState;
            UniqueEnchantmentsBase.NETWORKING.sendToServer(new KeyPacket((Object2BooleanMap<String>)keyState));
        }
    }

    @Override
    public IKeyBind registerKey(String name, int keyBinding) {
        return this.keys.computeIfAbsent(name, T -> new ClientPlayerKey((String)T, keyBinding));
    }

    public class ClientPlayerKey
    implements IKeyBind {
        String name;
        KeyBinding binding;

        public ClientPlayerKey(String name, int key) {
            this.name = name;
            this.binding = new KeyBinding(name, key, "UE Keys");
            ClientRegistry.registerKeyBinding((KeyBinding)this.binding);
        }

        public void appendState(Object2BooleanMap<String> map) {
            map.put((Object)this.name, this.getState());
        }

        public boolean getState() {
            return GameSettings.func_100015_a((KeyBinding)this.binding);
        }

        @Override
        public boolean test(EntityPlayer t) {
            return this.getState();
        }

        @Override
        public String getKeyName() {
            return this.binding.getDisplayName();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

