/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.handler;

import java.util.function.IntToDoubleFunction;

public final class MathCache {
    public static final int CACHESIZE = 100000;
    public static final MathCache POW3 = new MathCache(100000, MathCache::pow3);
    public static final MathCache POW5 = new MathCache(100000, MathCache::pow5);
    public static final MathCache POW_WEIRD = new MathCache(100000, MathCache::powWeird);
    public static final MathCache LOG = new MathCache(100000, Math::log);
    public static final MathCache LOG_MAX = new MathCache(100000, MathCache::logMaxLevel);
    public static final MathCache LOG_ADD = new MathCache(100000, MathCache::logAddLevel);
    public static final MathCache LOG_ADD_MAX = new MathCache(100000, MathCache::logAddMaxLevel);
    public static final MathCache LOG_MUL_MAX = new MathCache(100000, MathCache::logMulMaxLevel);
    public static final MathCache LOG101 = new MathCache(100000, MathCache::log101);
    public static final MathCache LOG10 = new MathCache(100000, Math::log10);
    final double[] cache;
    final IntToDoubleFunction generator;

    public MathCache(int size, IntToDoubleFunction generator) {
        this.generator = generator;
        this.cache = new double[size];
        for (int i = 0; i < size; ++i) {
            this.cache[i] = generator.applyAsDouble(i);
        }
    }

    public double get(int level) {
        return level >= this.cache.length ? this.generator.applyAsDouble(level) : this.cache[level];
    }

    public float getFloat(int level) {
        return (float)this.get(level);
    }

    public int getInt(int level) {
        return (int)this.get(level);
    }

    private static double pow3(int level) {
        return Math.pow(level, 3.0);
    }

    private static double pow5(int level) {
        return Math.pow(level, 5.0);
    }

    private static double powWeird(int level) {
        return Math.pow(1 + level * level / 100, 1 + level / 100);
    }

    private static double logAddMaxLevel(int level) {
        return Math.log(2.8 + (double)level * 0.0625);
    }

    private static double logMulMaxLevel(int level) {
        return Math.log(2.8 * (double)level * 0.0625);
    }

    private static double logMaxLevel(int level) {
        return Math.log(2.8 * (double)level);
    }

    private static double logAddLevel(int level) {
        return Math.log(2.8 + (double)level);
    }

    private static double log101(int level) {
        return Math.log((double)level + 1.1);
    }
}

