/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.jei;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uniquebase.jei.WrappedEnchantment;

public class EnchantmentWrapper
implements IRecipeWrapper {
    WrappedEnchantment enchantment;
    int pageIndex = 0;
    GuiButtonExt left = new GuiButtonExt(0, 1, 59, 10, 10, "<");
    GuiButtonExt right = new GuiButtonExt(0, 54, 59, 10, 10, ">");

    public EnchantmentWrapper(WrappedEnchantment enchantment) {
        this.enchantment = enchantment;
    }

    public void getIngredients(IIngredients ingridients) {
        int i;
        ObjectArrayList list = new ObjectArrayList();
        for (i = 0; i < 7; ++i) {
            list.add(new ObjectArrayList());
        }
        int m = this.enchantment.validItems.size();
        for (i = 0; i < m; ++i) {
            ((List)list.get(1 + i % 6)).add(this.enchantment.validItems.get(i));
        }
        m = this.enchantment.ench.func_77325_b();
        for (i = this.enchantment.ench.func_77319_d(); i <= m; ++i) {
            ItemStack stack = new ItemStack(Items.field_151134_bR);
            ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(this.enchantment.ench, i));
            ((List)list.get(0)).add(stack);
        }
        ingridients.setInputLists(VanillaTypes.ITEM, (List)list);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer font = minecraft.field_71466_p;
        String s = TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.enchantment.ench.func_77320_a(), (Object[])new Object[0]);
        font.func_78276_b(s, 85 - font.func_78256_a(s) / 2, 3, 0);
        font.func_78276_b(I18n.func_135052_a((String)"unique.base.jei.max_level", (Object[])new Object[]{TextFormatting.WHITE.toString() + this.enchantment.ench.func_77325_b()}), 3, 18, 1889913);
        font.func_78276_b(I18n.func_135052_a((String)"unique.base.jei.treasure", (Object[])new Object[0]), 3, 28, 12226829);
        font.func_78276_b(I18n.func_135052_a((String)"unique.base.jei.curse", (Object[])new Object[0]), 3, 38, 10558997);
        font.func_78276_b(I18n.func_135052_a((String)"unique.base.jei.rarity", (Object[])new Object[]{this.getFormatting(this.enchantment.ench.func_77324_c()) + I18n.func_135052_a((String)("unique.base.jei." + this.enchantment.ench.func_77324_c().name().toLowerCase()), (Object[])new Object[0])}), 3, 48, 13310417);
        s = this.getDescription();
        if (font.func_78267_b(s, 95) / font.field_78288_b > 7) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            font.func_78279_b(s, 138, 126, 190, 0);
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)1.0);
        } else {
            font.func_78279_b(s, 69, 63, 95, 0);
        }
        font.func_78276_b("" + this.pageIndex, 28, 60, 0);
        List<String> incomp = this.getIncompats(font);
        int start = this.pageIndex * 10;
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        font.func_78276_b(I18n.func_135052_a((String)"unique.base.jei.incompats", (Object[])new Object[0]), 5, 144, 0);
        for (int i = 0; i < 11 && start + i < incomp.size(); ++i) {
            font.func_78276_b(incomp.get(start + i), 5, 164 + i * font.field_78288_b, 0);
        }
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)1.0);
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/beacon.png"));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        Gui.func_146110_a((int)(3 + font.func_78256_a(I18n.func_135052_a((String)"unique.base.jei.treasure", (Object[])new Object[0])) * 2), (int)55, (float)(90 + (this.enchantment.ench.func_185261_e() ? 0 : 22)), (float)220.0f, (int)18, (int)18, (float)256.0f, (float)256.0f);
        Gui.func_146110_a((int)(3 + font.func_78256_a(I18n.func_135052_a((String)"unique.base.jei.curse", (Object[])new Object[0])) * 2), (int)74, (float)(90 + (this.enchantment.ench.func_190936_d() ? 0 : 22)), (float)220.0f, (int)18, (int)18, (float)256.0f, (float)256.0f);
        GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)1.0);
        this.left.field_146124_l = this.pageIndex > 0;
        this.right.field_146124_l = this.pageIndex < incomp.size() / 11;
        this.left.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
        this.right.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.left.func_146116_c(minecraft, mouseX, mouseY) && this.pageIndex > 0) {
            this.left.func_146113_a(minecraft.func_147118_V());
            --this.pageIndex;
            return true;
        }
        if (this.right.func_146116_c(minecraft, mouseX, mouseY) && this.pageIndex < this.getIncompats(minecraft.field_71466_p).size() / 11) {
            this.right.func_146113_a(minecraft.func_147118_V());
            ++this.pageIndex;
            return true;
        }
        return false;
    }

    private List<String> getIncompats(FontRenderer font) {
        ObjectArrayList list = new ObjectArrayList();
        if (this.enchantment.incompats.isEmpty()) {
            list.addAll(font.func_78271_c("- " + I18n.func_135052_a((String)"unique.base.jei.no.incompat", (Object[])new Object[0]), 122));
        } else {
            for (Enchantment ench : this.enchantment.incompats) {
                list.addAll(font.func_78271_c("- " + I18n.func_135052_a((String)ench.func_77320_a(), (Object[])new Object[0]), 122));
            }
        }
        return list;
    }

    private String getDescription() {
        String s = I18n.func_135052_a((String)("enchantment." + this.enchantment.ench.getRegistryName().func_110624_b() + "." + this.enchantment.ench.getRegistryName().func_110623_a() + ".desc"), (Object[])new Object[0]);
        if (s.startsWith("enchantment.")) {
            return I18n.func_135052_a((String)"unique.base.jei.no.description", (Object[])new Object[0]);
        }
        return s;
    }

    private TextFormatting getFormatting(Enchantment.Rarity rarity) {
        switch (rarity) {
            case COMMON: {
                return TextFormatting.WHITE;
            }
            case RARE: {
                return TextFormatting.AQUA;
            }
            case UNCOMMON: {
                return TextFormatting.YELLOW;
            }
            case VERY_RARE: {
                return TextFormatting.LIGHT_PURPLE;
            }
        }
        return TextFormatting.OBFUSCATED;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }
}

