/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.networking;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uniquebase.api.BaseUEMod;
import uniquebase.networking.ChannelManager;
import uniquebase.networking.EntityPacket;
import uniquebase.networking.IUEPacket;
import uniquebase.networking.KeyPacket;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<IUEPacket> {
    EnumMap<Side, FMLEmbeddedChannel> channel;
    ChannelManager packetRegistry = new ChannelManager();

    public PacketHandler() {
        this.channel = NetworkRegistry.INSTANCE.newChannel("ue", new ChannelHandler[]{this.packetRegistry, this});
        this.packetRegistry.addDiscriminator(0, EntityPacket.class);
        this.packetRegistry.addDiscriminator(1, KeyPacket.class);
    }

    public void registerInternalPacket(BaseUEMod mod, Class<? extends IUEPacket> packet, int id) {
        if (mod == null || !BaseUEMod.containsMod(mod)) {
            throw new IllegalStateException("A non UE Addon tried registering a Internal Network packet. Not allowed since Ids are hardcoded and have to be the same");
        }
        this.packetRegistry.addDiscriminator(id, packet);
    }

    public void sendToPlayer(IUEPacket packet, EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            FMLLog.log.info("UE Networking: Invalid Player Found: " + player);
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public void sendToServer(IUEPacket packet) {
        this.channel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channel.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public void sendToAllPlayers(IUEPacket packet) {
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public void sendToChunk(IUEPacket packet, Chunk chunk) {
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_POINT);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(chunk.func_177412_p().field_73011_w.getDimension(), (double)(chunk.field_76635_g * 16), 0.0, (double)(chunk.field_76647_h * 16), 0.0));
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    protected void channelRead0(ChannelHandlerContext ctx, IUEPacket msg) throws Exception {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        EntityPlayer player = this.getPlayer(netHandler);
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(netHandler);
        if (!thread.func_152345_ab()) {
            thread.func_152344_a(() -> this.handleMessage(msg, player));
            return;
        }
        this.handleMessage(msg, player);
    }

    private void handleMessage(IUEPacket packet, EntityPlayer player) {
        try {
            packet.handlePacket(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EntityPlayer getPlayer(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return this.getClientPlayer();
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

