/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.utils;

import net.minecraftforge.common.config.Configuration;
import uniquebase.utils.IStat;

public class DoubleLevelStats
implements IStat {
    String name;
    String comment;
    final double baseConfig;
    final double levelConfig;
    double base;
    double level;

    public DoubleLevelStats(String name, double base, double level) {
        this(name, base, level, null);
    }

    public DoubleLevelStats(String name, double base, double level, String comment) {
        this.name = name;
        this.comment = comment;
        this.baseConfig = base;
        this.levelConfig = level;
        this.base = base;
        this.level = level;
    }

    @Override
    public void handleConfig(Configuration config, String category) {
        this.base = config.get(category, this.name + "_base", this.baseConfig, this.comment).getDouble();
        this.level = config.get(category, this.name + "_level", this.levelConfig).getDouble();
    }

    public double getSqrt(double input) {
        return this.base + Math.sqrt(this.level * input);
    }

    public double getAsDouble(double level) {
        return this.base + this.level * level;
    }

    public float getAsFloat(float level) {
        return (float)(this.base + this.level * (double)level);
    }

    public float getDevided(int level) {
        return (float)(this.base / (this.level * (double)level));
    }

    public float getLogDevided(int level) {
        return (float)(this.base / (this.level * Math.log(level)));
    }

    public float getLogValue(double log, int level) {
        return (float)(this.base * Math.log(this.level * (double)level * log));
    }
}

