/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.utils;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import uniquebase.utils.MiscUtil;

public class EnchantmentContainer {
    private static final EntityEquipmentSlot[] SLOTS = EntityEquipmentSlot.values();
    Object2IntMap<Enchantment>[] enchantments = new Object2IntMap[EntityEquipmentSlot.values().length];
    Object2IntLinkedOpenHashMap<Enchantment> combinedEnchantments = null;
    int checkedSlots = 0;
    EntityLivingBase base;
    AllIterable iter = new AllIterable();

    public EnchantmentContainer(EntityLivingBase base) {
        this.base = base;
    }

    public Iterable<Map.Entry<EntityEquipmentSlot, Object2IntMap<Enchantment>>> getAll() {
        this.triggerAll();
        return this.iter;
    }

    public Iterable<Int2ObjectMap.Entry<ItemStack>> getEnchantedItems(Enchantment ench) {
        this.triggerAll();
        return new SpecialIterable(ench);
    }

    public int getEnchantment(Enchantment ench, EntityEquipmentSlot slot) {
        if (this.enchantments[slot.ordinal()] == null) {
            this.enchantments[slot.ordinal()] = MiscUtil.getEnchantments(this.base.func_184582_a(slot));
            ++this.checkedSlots;
        }
        return this.enchantments[slot.ordinal()].getInt((Object)ench);
    }

    public Object2IntMap.Entry<EntityEquipmentSlot> getEnchantedItem(Enchantment ench) {
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        if (slots.length <= 0) {
            return MiscUtil.NO_ENCHANTMENT;
        }
        int m = slots.length;
        for (int i = 0; i < m; ++i) {
            int level = this.getEnchantment(ench, slots[i]);
            if (level <= 0) continue;
            return new AbstractObject2IntMap.BasicEntry((Object)slots[i], level);
        }
        return MiscUtil.NO_ENCHANTMENT;
    }

    protected void triggerAll() {
        if (this.combinedEnchantments == null) {
            if (this.checkedSlots != this.enchantments.length) {
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    if (this.enchantments[slot.ordinal()] != null) continue;
                    this.enchantments[slot.ordinal()] = MiscUtil.getEnchantments(this.base.func_184582_a(slot));
                    ++this.checkedSlots;
                }
            }
            this.combinedEnchantments = new Object2IntLinkedOpenHashMap();
            for (int i = 0; i < this.checkedSlots; ++i) {
                for (Object2IntMap.Entry entry : this.enchantments[i].object2IntEntrySet()) {
                    this.combinedEnchantments.addTo(entry.getKey(), entry.getIntValue());
                }
            }
        }
    }

    public int getCombinedEnchantment(Enchantment ench) {
        this.triggerAll();
        return this.combinedEnchantments.getInt((Object)ench);
    }

    private class AllIterator
    implements Iterator<Map.Entry<EntityEquipmentSlot, Object2IntMap<Enchantment>>> {
        int i = 0;

        private AllIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < SLOTS.length;
        }

        @Override
        public Map.Entry<EntityEquipmentSlot, Object2IntMap<Enchantment>> next() {
            return new AbstractMap.SimpleEntry<EntityEquipmentSlot, Object2IntMap<Enchantment>>(SLOTS[this.i], EnchantmentContainer.this.enchantments[this.i++]);
        }
    }

    private class AllIterable
    implements Iterable<Map.Entry<EntityEquipmentSlot, Object2IntMap<Enchantment>>> {
        private AllIterable() {
        }

        @Override
        public Iterator<Map.Entry<EntityEquipmentSlot, Object2IntMap<Enchantment>>> iterator() {
            return new AllIterator();
        }
    }

    private class SpecialIterator
    implements Iterator<Int2ObjectMap.Entry<ItemStack>> {
        Enchantment ench;
        int i = 0;
        int lastResult = -1;

        public SpecialIterator(Enchantment ench) {
            this.ench = ench;
        }

        private void compute() {
            if (this.lastResult != -1) {
                return;
            }
            while (this.i < EnchantmentContainer.this.enchantments.length) {
                int level = EnchantmentContainer.this.enchantments[this.i].getInt((Object)this.ench);
                if (level > 0) {
                    this.lastResult = level;
                    return;
                }
                ++this.i;
            }
            this.lastResult = 0;
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.lastResult != 0;
        }

        @Override
        public Int2ObjectMap.Entry<ItemStack> next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            AbstractInt2ObjectMap.BasicEntry result = new AbstractInt2ObjectMap.BasicEntry(this.lastResult, (Object)EnchantmentContainer.this.base.func_184582_a(SLOTS[this.i]));
            this.lastResult = -1;
            ++this.i;
            return result;
        }
    }

    private class SpecialIterable
    implements Iterable<Int2ObjectMap.Entry<ItemStack>> {
        Enchantment ench;

        public SpecialIterable(Enchantment ench) {
            this.ench = ench;
        }

        @Override
        public Iterator<Int2ObjectMap.Entry<ItemStack>> iterator() {
            return new SpecialIterator(this.ench);
        }
    }
}

