/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uniquebase.utils.IStat;

public class IdStat
implements IStat {
    final String id;
    final IForgeRegistry<?> registry;
    Set<ResourceLocation> values = new ObjectOpenHashSet();
    List<String> defaultValues = new ObjectArrayList();
    final String comment;

    public IdStat(String config, IForgeRegistry<?> registry) {
        this(config, null, registry, new ResourceLocation[0]);
    }

    public IdStat(String config, String comment, IForgeRegistry<?> registry) {
        this(config, comment, registry, new ResourceLocation[0]);
    }

    public IdStat(String config, IForgeRegistry<?> registry, IForgeRegistryEntry<?> ... defaultValues) {
        this(config, null, registry, defaultValues);
    }

    public IdStat(String config, String comment, IForgeRegistry<?> registry, IForgeRegistryEntry<?> ... defaultValues) {
        this.id = config;
        this.comment = comment;
        this.registry = registry;
        for (IForgeRegistryEntry<?> entry : defaultValues) {
            this.values.add(entry.getRegistryName());
            this.defaultValues.add(entry.getRegistryName().toString());
        }
    }

    public IdStat(String config, IForgeRegistry<?> registry, ResourceLocation ... defaultValues) {
        this(config, null, registry, defaultValues);
    }

    public IdStat(String config, String comment, IForgeRegistry<?> registry, ResourceLocation ... defaultValues) {
        this.id = config;
        this.comment = comment;
        this.registry = registry;
        for (ResourceLocation entry : defaultValues) {
            this.values.add(entry);
            this.defaultValues.add(entry.toString());
        }
    }

    public void addDefault(IForgeRegistryEntry<?> ... defaultValues) {
        for (IForgeRegistryEntry<?> entry : defaultValues) {
            this.values.add(entry.getRegistryName());
            this.defaultValues.add(entry.getRegistryName().toString());
        }
    }

    public void addDefault(ResourceLocation ... defaultValues) {
        for (ResourceLocation entry : defaultValues) {
            this.values.add(entry);
            this.defaultValues.add(entry.toString());
        }
    }

    @Override
    public void handleConfig(Configuration config, String category) {
        String[] array = config.get(category, this.id, this.defaultValues.toArray(new String[this.defaultValues.size()]), this.comment).getStringList();
        this.values.clear();
        for (int i = 0; i < array.length; ++i) {
            try {
                ResourceLocation location = new ResourceLocation(array[i]);
                if (!this.registry.containsKey(location)) continue;
                this.values.add(location);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean contains(ResourceLocation location) {
        return this.values.contains(location);
    }
}

