/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.utils;

import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import uniquebase.api.IToggleEnchantment;

public class MiscUtil {
    public static final Object2IntMap.Entry<EntityEquipmentSlot> NO_ENCHANTMENT = new AbstractObject2IntMap.BasicEntry(null, 0);

    public static int getHardCap(Enchantment ench) {
        return ench instanceof IToggleEnchantment ? ((IToggleEnchantment)ench).getHardCap() : Integer.MAX_VALUE;
    }

    public static boolean isDisabled(Enchantment ench) {
        return ench instanceof IToggleEnchantment && !((IToggleEnchantment)ench).isEnabled();
    }

    public static int getPlayerLevel(Entity entity, int defaultValue) {
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).field_71068_ca : defaultValue;
    }

    public static double getArmorProtection(EntityLivingBase entity) {
        return (double)entity.func_70658_aO() + MiscUtil.getAttribute(entity, SharedMonsterAttributes.field_189429_h) * 2.5;
    }

    public static double getAttackSpeed(EntityLivingBase entity) {
        return MiscUtil.getAttribute(entity, SharedMonsterAttributes.field_188790_f, 0.0);
    }

    public static double getAttribute(EntityLivingBase entity, IAttribute attribute) {
        return MiscUtil.getAttribute(entity, attribute, 0.0);
    }

    public static double getAttribute(EntityLivingBase entity, IAttribute attribute, double defaultValue) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        return instance == null ? defaultValue : instance.func_111126_e();
    }

    public static double getBaseAttribute(EntityLivingBase entity, IAttribute attribute) {
        return MiscUtil.getBaseAttribute(entity, attribute, 0.0);
    }

    public static double getBaseAttribute(EntityLivingBase entity, IAttribute attribute, double defaultValue) {
        IAttributeInstance instance = entity.func_110148_a(attribute);
        return instance == null ? defaultValue : instance.func_111125_b();
    }

    public static NBTTagCompound getPersistentData(Entity entity) {
        NBTTagCompound data = entity.getEntityData().func_74775_l("PlayerPersisted");
        if (data.func_82582_d()) {
            entity.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)data);
        }
        return data;
    }

    public static int getEnchantmentLevel(Enchantment ench, ItemStack stack) {
        if (ench instanceof IToggleEnchantment && !((IToggleEnchantment)ench).isEnabled()) {
            return 0;
        }
        if (stack.func_190926_b()) {
            return 0;
        }
        NBTTagList list = stack.func_77986_q();
        if (list.func_82582_d()) {
            return 0;
        }
        int id = Enchantment.func_185258_b((Enchantment)ench);
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74762_e("id") != id) continue;
            return Math.min(tag.func_74762_e("lvl"), MiscUtil.getHardCap(ench));
        }
        return 0;
    }

    public static int getCombinedEnchantmentLevel(Enchantment ench, EntityLivingBase base) {
        if (ench instanceof IToggleEnchantment && !((IToggleEnchantment)ench).isEnabled()) {
            return 0;
        }
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        if (slots.length <= 0) {
            return 0;
        }
        int totalLevel = 0;
        for (int i = 0; i < slots.length; ++i) {
            totalLevel += MiscUtil.getEnchantmentLevel(ench, base.func_184582_a(slots[i]));
        }
        return totalLevel;
    }

    public static Object2IntMap<Enchantment> getEnchantments(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Object2IntMaps.emptyMap();
        }
        NBTTagList list = stack.func_77986_q();
        if (list.func_82582_d()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int m = list.func_74745_c();
        for (int i = 0; i < m; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)tag.func_74765_d("id"));
            if (enchantment == null || enchantment instanceof IToggleEnchantment && !((IToggleEnchantment)enchantment).isEnabled()) continue;
            map.put((Object)enchantment, Math.min(tag.func_74762_e("lvl"), MiscUtil.getHardCap(enchantment)));
        }
        return map;
    }

    public static EntityEquipmentSlot[] getEquipmentSlotsFor(Enchantment ench) {
        if (ench instanceof IToggleEnchantment && !((IToggleEnchantment)ench).isEnabled()) {
            return new EntityEquipmentSlot[0];
        }
        try {
            return (EntityEquipmentSlot[])ReflectionHelper.getPrivateValue(Enchantment.class, (Object)ench, (String)"applicableEquipmentTypes", (String)"field_185263_a");
        }
        catch (Exception exception) {
            return new EntityEquipmentSlot[0];
        }
    }

    public static Set<EntityEquipmentSlot> getSlotsFor(Enchantment ench) {
        if (ench instanceof IToggleEnchantment && !((IToggleEnchantment)ench).isEnabled()) {
            return Collections.emptySet();
        }
        Object[] slots = MiscUtil.getEquipmentSlotsFor(ench);
        return slots.length <= 0 ? Collections.emptySet() : new ObjectLinkedOpenHashSet(slots);
    }

    public static Object2IntMap.Entry<EntityEquipmentSlot> getEnchantedItem(Enchantment enchantment, EntityLivingBase base) {
        if (enchantment instanceof IToggleEnchantment && !((IToggleEnchantment)enchantment).isEnabled()) {
            return NO_ENCHANTMENT;
        }
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor(enchantment);
        if (slots.length <= 0) {
            return NO_ENCHANTMENT;
        }
        for (int i = 0; i < slots.length; ++i) {
            int level = MiscUtil.getEnchantmentLevel(enchantment, base.func_184582_a(slots[i]));
            if (level <= 0) continue;
            return new AbstractObject2IntMap.BasicEntry((Object)slots[i], level);
        }
        return NO_ENCHANTMENT;
    }

    public static boolean harvestBlock(BlockEvent.BreakEvent event, IBlockState state, BlockPos pos) {
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, (EntityPlayer)player)) {
            return false;
        }
        World world = event.getWorld();
        world.func_180498_a((EntityPlayer)player, 2001, pos, Block.func_176210_f((IBlockState)state));
        boolean flag1 = false;
        if (player.func_184812_l_()) {
            flag1 = MiscUtil.removeBlock(world, pos, (EntityPlayer)player, false);
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l();
            boolean flag = state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_179548_a(world, state, pos, (EntityPlayer)player);
                if (itemstack1.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack2, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            if ((flag1 = MiscUtil.removeBlock(world, pos, (EntityPlayer)player, flag)) && flag) {
                state.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, state, world.func_175625_s(pos), itemstack2);
            }
        }
        if (!player.func_184812_l_() && flag1 && event.getExpToDrop() > 0) {
            state.func_177230_c().func_180637_b(world, pos, event.getExpToDrop());
        }
        return true;
    }

    private static boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, canHarvest);
        if (flag) {
            iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
        }
        return flag;
    }

    public static int drainExperience(EntityPlayer player, int points) {
        if (player.func_184812_l_()) {
            return points;
        }
        int totalXP = MiscUtil.getXP(player);
        if (totalXP != player.field_71067_cb) {
            player.field_71067_cb = totalXP;
        }
        int change = Math.min(MiscUtil.getXP(player), points);
        player.field_71067_cb -= change;
        player.field_71068_ca = MiscUtil.getLvlForXP(player.field_71067_cb);
        player.field_71106_cc = (float)(player.field_71067_cb - MiscUtil.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
        player.func_192024_a(ItemStack.field_190927_a, 0);
        return change;
    }

    public static int getXP(EntityPlayer player) {
        return MiscUtil.getXPForLvl(player.field_71068_ca) + DoubleMath.roundToInt((double)(player.field_71106_cc * (float)player.func_71050_bK()), (RoundingMode)RoundingMode.HALF_UP);
    }

    public static int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    public static int getLvlForXP(int totalXP) {
        int result = 0;
        while (MiscUtil.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }
}

