/*
 * Decompiled with CFR 0.152.
 */
package uniquebase.utils;

import java.util.List;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import uniquebase.utils.ObjIntFunction;

public class StackUtils {
    public static int getInt(ItemStack stack, String tagName, int defaultValue) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74762_e(tagName);
    }

    public static void setInt(ItemStack stack, String tagName, int value) {
        stack.func_77983_a(tagName, (NBTBase)new NBTTagInt(value));
    }

    public static long getLong(ItemStack stack, String tagName, long defaultValue) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null || !nbt.func_74764_b(tagName) ? defaultValue : nbt.func_74763_f(tagName);
    }

    public static void setLong(ItemStack stack, String tagName, long value) {
        stack.func_77983_a(tagName, (NBTBase)new NBTTagLong(value));
    }

    public static void growStack(ItemStack source, int size, List<ItemStack> output) {
        while (size > 0) {
            ItemStack stack = source.func_77946_l();
            stack.func_190920_e(Math.min(size, stack.func_77976_d()));
            output.add(stack);
            size -= stack.func_190916_E();
        }
    }

    public static ItemStack getArrowStack(EntityArrow arrow) {
        try {
            return (ItemStack)ReflectionHelper.findMethod(EntityArrow.class, (String)"getArrowStack", (String)"func_184550_j", (Class[])new Class[0]).invoke((Object)arrow, new Object[0]);
        }
        catch (Exception exception) {
            if (arrow instanceof EntitySpectralArrow) {
                return new ItemStack(Items.field_185166_h);
            }
            if (arrow instanceof EntityTippedArrow) {
                NBTTagCompound nbt = new NBTTagCompound();
                arrow.func_70014_b(nbt);
                if (nbt.func_74764_b("CustomPotionEffects")) {
                    ItemStack stack = new ItemStack(Items.field_185167_i);
                    stack.func_77983_a("CustomPotionEffects", nbt.func_74781_a("CustomPotionEffects"));
                    return stack;
                }
                return new ItemStack(Items.field_151032_g);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static boolean isOre(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == Items.field_190931_a) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(item, 1, item.func_77647_b(state.func_177230_c().func_176201_c(state))))) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            return true;
        }
        return false;
    }

    public static boolean isGem(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == Items.field_190931_a) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(item, 1, item.func_77647_b(state.func_177230_c().func_176201_c(state))))) {
            String gem = OreDictionary.getOreName((int)id);
            if (!gem.startsWith("ore") || !OreDictionary.doesOreNameExist((String)("gem" + gem.substring(3)))) continue;
            return true;
        }
        return false;
    }

    public static int evenDistribute(int xpPoints, Random rand, List<ItemStack> items, ObjIntFunction<ItemStack> consumer) {
        int left = xpPoints;
        while (left >= items.size() && items.size() > 0) {
            int xpPerItem = left / items.size();
            for (int i = 0; i < items.size(); ++i) {
                int consumed = consumer.apply(items.get(i), xpPerItem);
                if (consumed <= xpPerItem) {
                    items.remove(i--);
                }
                left -= consumed;
            }
        }
        if (!items.isEmpty()) {
            int startIndex = rand.nextInt(items.size());
            while (left > 0 && items.size() > 0) {
                int consumed = consumer.apply(items.get(startIndex), 1);
                if (consumed <= 0) {
                    items.remove(startIndex--);
                }
                left -= consumed;
                if (items.isEmpty()) break;
                ++startIndex;
                startIndex %= items.size();
            }
        }
        return xpPoints - left;
    }

    public static int consumeItems(EntityPlayer player, ToIntFunction<ItemStack> validator, int limit) {
        int found = 0;
        NonNullList inv = player.field_71071_by.field_70462_a;
        int m = inv.size();
        for (int i = 0; i < m; ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            int value = validator.applyAsInt(stack);
            if (value <= 0) continue;
            int left = limit - found;
            if (left >= stack.func_190916_E() * value) {
                found += stack.func_190916_E() * value;
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    inv.set(i, (Object)stack.func_77973_b().getContainerItem(stack));
                    continue;
                }
                inv.set(i, (Object)ItemStack.field_190927_a);
            } else if (left / value > 0) {
                stack.func_190918_g(left / value);
                found += left;
            }
            if (found >= limit) break;
        }
        return found;
    }

    public static int hasBlockCount(World world, BlockPos pos, int limit, ToIntFunction<IBlockState> validator) {
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        int found = 0;
        for (int y = 0; y <= 1; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    newPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if ((found += validator.applyAsInt(world.func_180495_p((BlockPos)newPos))) < limit) continue;
                    return limit;
                }
            }
        }
        return found;
    }
}

