/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.complex;

import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleStat;
import uniquebase.utils.EnchantmentContainer;
import uniquebase.utils.IStat;
import uniquebase.utils.IntStat;
import uniquebase.utils.MiscUtil;
import uniquebase.utils.StackUtils;
import uniquee.UniqueEnchantments;

public class EnderMending
extends UniqueEnchantment {
    public static final String ENDER_TAG = "ender_mending";
    public static final DoubleStat THRESHOLD = new DoubleStat(1.0, "threshold");
    public static final IntStat LIMIT = new IntStat(250, "storage_limit");
    public static final DoubleStat LIMIT_MULTIPLIER = new DoubleStat(1.72, "storage_limit_multiplier");
    public static final IntSet VALID_ENCHANTMENTS = new IntLinkedOpenHashSet();

    public EnderMending() {
        super(new UniqueEnchantment.DefaultData(ENDER_TAG, Enchantment.Rarity.VERY_RARE, 3, true, 20, 10, 5), EnumEnchantmentType.BREAKABLE, EntityEquipmentSlot.values());
        this.addStats(new IStat[]{THRESHOLD, LIMIT, LIMIT_MULTIPLIER});
    }

    public void loadIncompats() {
        this.addIncompats(new Enchantment[]{Enchantments.field_185296_A, UniqueEnchantments.ENDERMARKSMEN, UniqueEnchantments.WARRIORS_GRACE, UniqueEnchantments.ECOLOGICAL});
    }

    protected boolean canNotApplyToItems(ItemStack stack) {
        return EnumEnchantmentType.ARMOR.func_77557_a(stack.func_77973_b());
    }

    public void loadData(Configuration config) {
        String[] repairs = config.getStringList("repaireable_enchantments", this.getConfigName(), new String[]{Enchantments.field_185296_A.getRegistryName().toString(), UniqueEnchantments.ENDER_MENDING.getRegistryName().toString(), UniqueEnchantments.GRIMOIRE.getRegistryName().toString()}, "Enchantments should be allowed to repaired by Ender mending");
        VALID_ENCHANTMENTS.clear();
        int m = repairs.length;
        for (int i = 0; i < m; ++i) {
            try {
                VALID_ENCHANTMENTS.add(Enchantment.func_185258_b((Enchantment)Enchantment.func_180305_b((String)repairs[i])));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void shareXP(EntityPlayer player, EnchantmentContainer container) {
        EntityEquipmentSlot hasSlot = null;
        int stored = 0;
        for (Map.Entry entry : container.getAll()) {
            int level = ((Object2IntMap)entry.getValue()).getInt((Object)UniqueEnchantments.ENDER_MENDING);
            if (level <= 0) continue;
            double xpProvided = 1.0 / (1.0 + THRESHOLD.get((double)level) / 100.0);
            int required = (int)((double)MathHelper.func_76143_f((double)((double)LIMIT.get() * Math.pow(LIMIT_MULTIPLIER.get(), Math.sqrt(level)))) * xpProvided);
            int found = StackUtils.getInt((ItemStack)player.func_184582_a((EntityEquipmentSlot)entry.getKey()), (String)ENDER_TAG, (int)0);
            if (found < required) continue;
            hasSlot = (EntityEquipmentSlot)entry.getKey();
            stored = found;
            break;
        }
        if (hasSlot == null) {
            return;
        }
        ObjectArrayList found = new ObjectArrayList();
        int m = player.field_71071_by.func_70302_i_();
        block1: for (int i2 = 0; i2 < m; ++i2) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i2);
            if (stack2.func_190926_b() || !stack2.func_77951_h()) continue;
            Object2IntMap enchantments = MiscUtil.getEnchantments((ItemStack)stack2);
            for (Enchantment ench : enchantments.keySet()) {
                if (!VALID_ENCHANTMENTS.contains(Enchantment.func_185258_b((Enchantment)ench))) continue;
                found.add(stack2);
                continue block1;
            }
        }
        int last = stored;
        if (last != (stored -= StackUtils.evenDistribute((int)stored, (Random)player.field_70170_p.field_73012_v, (List)found, (stack, i) -> {
            int used = Math.min(i, stack.func_77952_i());
            stack.func_77964_b(stack.func_77952_i() - used);
            return used;
        }))) {
            StackUtils.setInt((ItemStack)player.func_184582_a(hasSlot), (String)ENDER_TAG, (int)stored);
        }
    }
}

