/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.simple;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleStat;
import uniquebase.utils.IStat;
import uniquebase.utils.IntLevelStats;
import uniquee.UniqueEnchantments;

public class AmelioratedBaneOfArthropod
extends UniqueEnchantment {
    public static final DoubleStat BONUS_DAMAGE = new DoubleStat(3.0, "bonus_damage");
    public static final IntLevelStats SLOW_DURATION = new IntLevelStats("slow_duration", 40, 15);

    public AmelioratedBaneOfArthropod() {
        super(new UniqueEnchantment.DefaultData("arthropods", Enchantment.Rarity.RARE, 5, true, 6, 4, 30), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.addStats(new IStat[]{BONUS_DAMAGE, SLOW_DURATION});
    }

    public void loadIncompats() {
        this.addIncompats(new Enchantment[]{Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n});
        this.addIncompats(new Enchantment[]{UniqueEnchantments.ADV_SHARPNESS, UniqueEnchantments.ADV_SMITE});
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b() instanceof ItemHoe;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        return creatureType == EnumCreatureAttribute.ARTHROPOD ? BONUS_DAMAGE.getFloat((float)level) : 0.0f;
    }

    public void func_151368_a(EntityLivingBase user, Entity target, int level) {
        EntityLivingBase entitylivingbase;
        if (target instanceof EntityLivingBase && (entitylivingbase = (EntityLivingBase)target).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
            entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, SLOW_DURATION.get(level), 3));
        }
    }
}

