/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.MiscUtil;
import uniquee.UniqueEnchantments;

public class AlchemistsGrace
extends UniqueEnchantment {
    public static final List<List<PotionPlan>> EFFECTS = new ObjectArrayList();

    public AlchemistsGrace() {
        super(new UniqueEnchantment.DefaultData("alchemistsgrace", Enchantment.Rarity.VERY_RARE, 4, true, 18, 6, 40).setHardCap(33), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemHoe || EnumEnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    public void loadIncompats() {
        this.addIncompats(new Enchantment[]{UniqueEnchantments.WARRIORS_GRACE, UniqueEnchantments.NATURES_GRACE});
    }

    public static void applyToEntity(Entity entity, boolean mining, float hitScalar) {
        EntityLivingBase base;
        Object2IntMap.Entry slot;
        if (entity instanceof EntityLivingBase && (slot = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.ALCHEMISTS_GRACE, (EntityLivingBase)(base = (EntityLivingBase)entity))).getIntValue() > 0) {
            hitScalar = Math.max(0.5f, hitScalar);
            int level = slot.getIntValue();
            ObjectOpenHashSet potions = new ObjectOpenHashSet();
            for (int i = level; i >= 0; --i) {
                if (EFFECTS.size() <= i) continue;
                for (PotionPlan plan : EFFECTS.get(i)) {
                    PotionEffect effect;
                    if (!plan.isValid(mining) || !potions.add((effect = plan.createEffect(level, hitScalar)).func_188419_a())) continue;
                    base.func_70690_d(effect);
                }
            }
        }
    }

    public void loadData(Configuration config) {
        String[] potions;
        EFFECTS.clear();
        for (String s : potions = config.getStringList("effects", this.getConfigName(), new String[]{"minecraft:regeneration;1;0;0.25;10;true;false", "minecraft:speed;1;0;1.0;60;true;true", "minecraft:haste;2;0;1.0;40;true;true", "minecraft:speed;2;1;0.5;70;true;true", "minecraft:resistance;3;0;1.0;20;true;false", "minecraft:haste;3;1;0.5;60;true;true", "minecraft:strength;4;0;1.0;20;true;false", "minecraft:resistance;4;1;0.25;25;true;false", "minecraft:fire_resistance;4;0;1.0;30;false;true", "minecraft:strength;5;1;0.2;30;true;false"}, "Which Potion Effects should be applied. Format: Potion;StartEnchantmentLvL;StartPotionLvL;PotionLvLPerEnchantLvL;BaseDuration;Fighting;Mining")) {
            Potion p;
            String[] split = s.split(";");
            if (split.length != 7 || (p = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(split[0]))) == null) continue;
            try {
                PotionPlan plan = new PotionPlan(p, split);
                while (EFFECTS.size() <= plan.baseEnchantment) {
                    EFFECTS.add((List<PotionPlan>)new ObjectArrayList());
                }
                EFFECTS.get(plan.baseEnchantment).add(plan);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class PotionPlan {
        Potion potion;
        int baseEnchantment;
        int basePotionLevel;
        double PotionLevelIncrease;
        int baseDuration;
        boolean fighting;
        boolean mining;

        public PotionPlan(Potion potion, String[] data) {
            this.potion = potion;
            this.baseEnchantment = Integer.parseInt(data[1]);
            this.basePotionLevel = Integer.parseInt(data[2]);
            this.PotionLevelIncrease = Double.parseDouble(data[3]);
            this.baseDuration = Integer.parseInt(data[4]);
            this.fighting = Boolean.parseBoolean(data[5]);
            this.mining = Boolean.parseBoolean(data[6]);
        }

        public PotionEffect createEffect(int baseLevel, float hitScalar) {
            int diff = Math.max(0, baseLevel - this.baseEnchantment);
            return new PotionEffect(this.potion, (int)((double)this.baseDuration * Math.log((hitScalar + 0.5f) * (float)baseLevel)), this.basePotionLevel + (int)(this.PotionLevelIncrease * (double)diff));
        }

        public boolean isValid(boolean mining) {
            return mining ? this.mining : this.fighting;
        }
    }
}

