/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleLevelStats;
import uniquebase.utils.EnchantmentContainer;
import uniquebase.utils.IStat;
import uniquebase.utils.IntStat;
import uniquee.UniqueEnchantments;

public class ClimateTranquility
extends UniqueEnchantment {
    public static final UUID SPEED_UUID = UUID.fromString("7b8a3791-8f94-4127-82b2-26418679d551");
    public static final DoubleLevelStats SPEED_BONUS = new DoubleLevelStats("speed_bonus", 0.1, 0.03);
    public static final IntStat SLOW_TIME = new IntStat(30, "slow_duration");
    public static final UUID ATTACK_UUID = UUID.fromString("b47bd399-5ad0-4f1d-a0eb-0a9146ff1734");
    public static final DoubleLevelStats ATTACK_BONUS = new DoubleLevelStats("attack_bonus", 0.1, 0.03);
    public static final IntStat BURN_TIME = new IntStat(1, "burn_time");

    public ClimateTranquility() {
        super(new UniqueEnchantment.DefaultData("climate_tranquility", Enchantment.Rarity.RARE, 3, true, 20, 7, 30), EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.addStats(new IStat[]{SPEED_BONUS, SLOW_TIME, ATTACK_BONUS, BURN_TIME});
    }

    protected boolean canApplyToItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemAxe || EnumEnchantmentType.BOW.func_77557_a(stack.func_77973_b());
    }

    public static void onClimate(EntityPlayer player, EnchantmentContainer container) {
        Object2IntMap.Entry slot = container.getEnchantedItem(UniqueEnchantments.CLIMATE_TRANQUILITY);
        AbstractAttributeMap map = player.func_110140_aT();
        IAttributeInstance speed = map.func_111151_a(SharedMonsterAttributes.field_188790_f);
        IAttributeInstance damage = map.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (slot.getIntValue() <= 0) {
            speed.func_188479_b(SPEED_UUID);
            damage.func_188479_b(ATTACK_UUID);
            return;
        }
        int level = slot.getIntValue();
        Set effects = BiomeDictionary.getTypes((Biome)player.field_70170_p.func_180494_b(player.func_180425_c()));
        boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
        boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
        if (hasHot && !hasCold) {
            AttributeModifier speedMod = new AttributeModifier(SPEED_UUID, "Climate Boost", SPEED_BONUS.getAsDouble((double)level), 2);
            if (!speed.func_180374_a(speedMod)) {
                speed.func_111121_a(speedMod);
            }
        } else {
            speed.func_188479_b(SPEED_UUID);
        }
        if (hasCold && !hasHot) {
            AttributeModifier damageMod = new AttributeModifier(ATTACK_UUID, "Climate Boost", ATTACK_BONUS.getAsDouble((double)level), 2);
            if (!damage.func_180374_a(damageMod)) {
                damage.func_111121_a(damageMod);
            }
        } else {
            damage.func_188479_b(ATTACK_UUID);
        }
    }
}

