/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.shorts.ShortLinkedOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleStat;
import uniquebase.utils.IStat;
import uniquebase.utils.IntStat;
import uniquee.UniqueEnchantments;

public class Grimoire
extends UniqueEnchantment {
    public static final String GRIMOIRE_LEVEL = "grimoire_level";
    public static final String GRIMOIRE_STORAGE = "grimoire_storage";
    public static final String GRIMOIRE_OWNER = "grimoire_owner";
    public static final DoubleStat LEVEL_SCALING = new DoubleStat(0.9, "level_scaling");
    public static final DoubleStat STEP_SKIP = new DoubleStat(5.0, "step_skip");
    public static final IntStat START_LEVEL = new IntStat(50, "start_level");
    public static final ShortSet INCOMPATS = new ShortLinkedOpenHashSet();

    public Grimoire() {
        super(new UniqueEnchantment.DefaultData("grimoire", Enchantment.Rarity.VERY_RARE, 5, true, 70, 36, 20), EnumEnchantmentType.ALL, EntityEquipmentSlot.values());
        this.addStats(new IStat[]{LEVEL_SCALING, STEP_SKIP, START_LEVEL});
        this.setCurse();
    }

    public void loadIncompats() {
        this.addIncompats(new Enchantment[]{Enchantments.field_185296_A, UniqueEnchantments.ENDER_MENDING});
    }

    public void loadData(Configuration config) {
        String[] incompats = config.getStringList("ignored_enchantments", this.getConfigName(), this.getNames(), "Enchantments that should be ignored by this enchantment");
        INCOMPATS.clear();
        int m = incompats.length;
        for (int i = 0; i < m; ++i) {
            try {
                Enchantment ench = Enchantment.func_180305_b((String)incompats[i]);
                if (ench == null) continue;
                INCOMPATS.add((short)Enchantment.func_185258_b((Enchantment)ench));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getNames() {
        String[] defaults = new String[]{Enchantments.field_185308_t.getRegistryName().toString(), Enchantments.field_185305_q.getRegistryName().toString(), Enchantments.field_185304_p.getRegistryName().toString(), UniqueEnchantments.MIDAS_BLESSING.getRegistryName().toString(), UniqueEnchantments.ENDEST_REAP.getRegistryName().toString(), Enchantments.field_185296_A.getRegistryName().toString(), Enchantments.field_185306_r.getRegistryName().toString()};
        return defaults;
    }

    public static void applyGrimore(ItemStack stack, int level, EntityPlayer player) {
        int enchCount;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        int nextLevel = Math.max(0, MathHelper.func_76128_c((double)(Math.log((Math.max(1, START_LEVEL.get()) + player.field_71068_ca) * level) * LEVEL_SCALING.get() - STEP_SKIP.get())));
        int grimoreCount = compound.func_74764_b(GRIMOIRE_STORAGE) ? compound.func_150295_c(GRIMOIRE_STORAGE, 10).func_74745_c() : 0;
        int n = enchCount = compound.func_74764_b("ench") ? compound.func_150295_c("ench", 10).func_74745_c() : 0;
        if (compound.func_74762_e(GRIMOIRE_LEVEL) != nextLevel || grimoreCount != enchCount) {
            compound.func_74768_a(GRIMOIRE_LEVEL, nextLevel);
            if (compound.func_74764_b(GRIMOIRE_STORAGE)) {
                compound.func_74782_a("ench", compound.func_74781_a(GRIMOIRE_STORAGE));
                compound.func_82580_o(GRIMOIRE_STORAGE);
            }
            NBTTagList ench = compound.func_150295_c("ench", 10);
            compound.func_74782_a(GRIMOIRE_STORAGE, (NBTBase)ench);
            compound.func_82580_o("ench");
            NBTTagList list = new NBTTagList();
            short exclusion = (short)Enchantment.func_185258_b((Enchantment)UniqueEnchantments.GRIMOIRE);
            int m = ench.func_74745_c();
            for (int i = 0; i < m; ++i) {
                NBTTagCompound enchantment = ench.func_150305_b(i);
                short id = enchantment.func_74765_d("id");
                NBTTagCompound copy = new NBTTagCompound();
                copy.func_74777_a("id", id);
                copy.func_74777_a("lvl", (short)(enchantment.func_74765_d("lvl") + (id == exclusion || INCOMPATS.contains(id) ? 0 : nextLevel)));
                list.func_74742_a((NBTBase)copy);
            }
            compound.func_74782_a("ench", (NBTBase)list);
        }
        if (compound.func_74764_b(GRIMOIRE_OWNER)) {
            if (!compound.func_186857_a(GRIMOIRE_OWNER).equals(player.func_110124_au())) {
                player.func_70097_a(DamageSource.field_76380_i, 1.0f);
            }
        } else {
            compound.func_186854_a(GRIMOIRE_OWNER, player.func_110124_au());
        }
        stack.func_77982_d(compound);
    }
}

