/*
 * Decompiled with CFR 0.152.
 */
package uniquee.enchantments.unique;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import uniquebase.api.UniqueEnchantment;
import uniquebase.utils.DoubleLevelStats;
import uniquebase.utils.IStat;

public class MidasBlessing
extends UniqueEnchantment {
    static Set<Item> VALID_ITEMS = new ObjectOpenHashSet();
    public static ToIntFunction<ItemStack> VALIDATOR = new ToIntFunction<ItemStack>(){

        @Override
        public int applyAsInt(ItemStack value) {
            return value.func_77973_b() == Items.field_151043_k || VALID_ITEMS.contains(value.func_77973_b()) ? 1 : 0;
        }
    };
    public static String GOLD_COUNTER = "gold_storage";
    public static final DoubleLevelStats GOLD_COST = new DoubleLevelStats("gold_cost", 1.0, 1.0);

    public MidasBlessing() {
        super(new UniqueEnchantment.DefaultData("midas_blessing", Enchantment.Rarity.VERY_RARE, 3, true, 14, 6, 75), EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.addStats(new IStat[]{GOLD_COST});
    }

    protected boolean canNotApplyToItems(ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemPickaxe);
    }

    public void loadIncompats() {
        this.addIncompats(new Enchantment[]{Enchantments.field_185308_t, Enchantments.field_185306_r});
    }

    public void loadData(Configuration config) {
        VALID_ITEMS.clear();
        String[] items = config.get(this.getConfigName(), "optional_gold_items", new String[0], "Optional Items that can be used as gold replacement. No meta-nbt support").getStringList();
        int m = items.length;
        for (int i = 0; i < m; ++i) {
            Item item = Item.func_111206_d((String)items[i]);
            if (item == Items.field_190931_a || item == null) continue;
            VALID_ITEMS.add(item);
        }
    }
}

