/*
 * Decompiled with CFR 0.152.
 */
package uniquee.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import uniquebase.UniqueEnchantmentsBase;
import uniquebase.handler.MathCache;
import uniquebase.networking.EntityPacket;
import uniquebase.networking.IUEPacket;
import uniquebase.utils.EnchantmentContainer;
import uniquebase.utils.MiscUtil;
import uniquebase.utils.StackUtils;
import uniquee.UniqueEnchantments;
import uniquee.enchantments.complex.EnderMending;
import uniquee.enchantments.complex.Momentum;
import uniquee.enchantments.complex.PerpetualStrike;
import uniquee.enchantments.complex.SmartAss;
import uniquee.enchantments.complex.SpartanWeapon;
import uniquee.enchantments.complex.SwiftBlade;
import uniquee.enchantments.curse.DeathsOdium;
import uniquee.enchantments.curse.PestilencesOdium;
import uniquee.enchantments.simple.Berserk;
import uniquee.enchantments.simple.BoneCrusher;
import uniquee.enchantments.simple.EnderEyes;
import uniquee.enchantments.simple.FocusImpact;
import uniquee.enchantments.simple.Range;
import uniquee.enchantments.simple.SagesBlessing;
import uniquee.enchantments.simple.Swift;
import uniquee.enchantments.simple.Vitae;
import uniquee.enchantments.unique.AlchemistsGrace;
import uniquee.enchantments.unique.AresBlessing;
import uniquee.enchantments.unique.ClimateTranquility;
import uniquee.enchantments.unique.Cloudwalker;
import uniquee.enchantments.unique.Ecological;
import uniquee.enchantments.unique.EnderMarksmen;
import uniquee.enchantments.unique.EndestReap;
import uniquee.enchantments.unique.FastFood;
import uniquee.enchantments.unique.Grimoire;
import uniquee.enchantments.unique.IcarusAegis;
import uniquee.enchantments.unique.IfritsGrace;
import uniquee.enchantments.unique.MidasBlessing;
import uniquee.enchantments.unique.NaturesGrace;
import uniquee.enchantments.unique.PhoenixBlessing;
import uniquee.enchantments.unique.WarriorsGrace;
import uniquee.handler.ai.AISpecialFindPlayer;

public class EntityEvents {
    public static final EntityEvents INSTANCE = new EntityEvents();
    public static final ThreadLocal<UUID> ENDERMEN_TO_BLOCK = new ThreadLocal();
    public static final ThreadLocal<Boolean> BREAKING = ThreadLocal.withInitial(() -> false);

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityEnderman) {
            EntityAITasks tasks = ((EntityEnderman)entity).field_70715_bh;
            for (EntityAITasks.EntityAITaskEntry task : new ObjectArrayList((Collection)tasks.field_75782_a)) {
                if (task.field_75731_b != 1 || !(task.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                tasks.func_85156_a(task.field_75733_a);
                tasks.func_75776_a(1, (EntityAIBase)new AISpecialFindPlayer((EntityEnderman)entity));
            }
        } else if (entity instanceof EntityItem && MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.GRIMOIRE, (ItemStack)((EntityItem)entity).func_92059_d()) > 0) {
            entity.func_184224_h(true);
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilUpdateEvent event) {
        if (MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.GRIMOIRE, (ItemStack)event.getLeft()) > 0) {
            event.setCost(Integer.MAX_VALUE);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int level;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        EnchantmentContainer container = new EnchantmentContainer((EntityLivingBase)player);
        if (event.side == Side.SERVER) {
            NBTTagCompound data;
            int value;
            int level2;
            if (player.func_110143_aJ() < player.func_110138_aP() && (level2 = container.getEnchantment(UniqueEnchantments.NATURES_GRACE, EntityEquipmentSlot.CHEST)) > 0 && player.field_70170_p.func_82737_E() % (long)Math.max((int)((double)NaturesGrace.DELAY.get() / MathCache.LOG101.get(level2)), 1) == 0L && player.func_110142_aN().func_94550_c() == null && (value = StackUtils.hasBlockCount((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (int)24, NaturesGrace.FLOWERS)) >= 4) {
                player.func_70691_i((float)Math.log(7.39 + Math.pow((float)Math.sqrt(value), MathCache.LOG.get(level2 + 1))));
            }
            if (player.field_70170_p.func_82737_E() % 1200L == 0L) {
                EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor((Enchantment)UniqueEnchantments.GRIMOIRE);
                for (int i = 0; i < slots.length; ++i) {
                    int level3 = container.getEnchantment(UniqueEnchantments.GRIMOIRE, slots[i]);
                    if (level3 <= 0) continue;
                    Grimoire.applyGrimore(player.func_184582_a(slots[i]), level3, player);
                }
            }
            if (player.field_70170_p.func_82737_E() % 400L == 0L) {
                EnderMending.shareXP(player, container);
            }
            if (player.field_70170_p.func_82737_E() % 100L == 0L) {
                for (Int2ObjectMap.Entry entry : container.getEnchantedItems(UniqueEnchantments.ENDER_MENDING)) {
                    int stored;
                    ItemStack stack = (ItemStack)entry.getValue();
                    if (!stack.func_77951_h() || (stored = StackUtils.getInt((ItemStack)stack, (String)"ender_mending", (int)0)) <= 0) continue;
                    int toRemove = Math.min(stack.func_77952_i(), stored);
                    stack.func_77964_b(stack.func_77952_i() - toRemove);
                    StackUtils.setInt((ItemStack)stack, (String)"ender_mending", (int)(stored - toRemove));
                }
                level2 = container.getEnchantment(UniqueEnchantments.ENDEST_REAP, EntityEquipmentSlot.MAINHAND);
                if (level2 > 0) {
                    StackUtils.setInt((ItemStack)player.func_184614_ca(), (String)"reap_storage", (int)player.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("reap_storage"));
                }
            }
            if (player.field_70170_p.func_82737_E() % 30L == 0L) {
                ClimateTranquility.onClimate(player, container);
            }
            if (player.field_70170_p.func_82737_E() % 10L == 0L && (level2 = container.getEnchantment(UniqueEnchantments.ICARUS_AEGIS, EntityEquipmentSlot.CHEST)) > 0) {
                player.func_184582_a(EntityEquipmentSlot.CHEST).func_77978_p().func_74757_a(IcarusAegis.FLYING_TAG, player.func_184613_cA());
            }
            if (player.field_70170_p.func_82737_E() % 40L == 0L && (level2 = container.getCombinedEnchantment(UniqueEnchantments.PESTILENCES_ODIUM)) > 0) {
                List living = player.field_70170_p.func_72872_a(EntityAgeable.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(PestilencesOdium.RADIUS.get(MathCache.LOG_ADD_MAX.get(level2))));
                int m = living.size();
                for (int i = 0; i < m; ++i) {
                    ((EntityAgeable)living.get(i)).func_70690_d(new PotionEffect(UniqueEnchantments.PESTILENCES_ODIUM_POTION, 200, level2));
                }
            }
            if (player.field_70170_p.func_82737_E() % 20L == 0L && (level = container.getEnchantedItem(UniqueEnchantments.SAGES_BLESSING)).getIntValue() > 0) {
                player.func_71020_j(0.01f * (float)level.getIntValue());
            }
            if ((data = event.player.getEntityData()).func_74764_b("curse_regain_damage") && data.func_74763_f("curse_regain_timer") < event.player.field_70170_p.func_82737_E()) {
                IAttributeInstance instance;
                AttributeModifier mod;
                int total = MathHelper.func_76141_d((float)(data.func_74760_g("curse_regain_damage") / (float)DeathsOdium.DAMAGE_FACTOR.get()));
                if (total > 0 && (mod = (instance = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a)).func_111127_a(DeathsOdium.REMOVE_UUID)) != null) {
                    double newValue = Math.max(0.0, mod.func_111164_d() - (double)total);
                    instance.func_111124_b(mod);
                    if (newValue > 0.0) {
                        instance.func_111121_a(new AttributeModifier(DeathsOdium.REMOVE_UUID, "odiums_curse", newValue, 0));
                    }
                }
                data.func_82580_o("curse_regain_damage");
            }
        }
        if ((level = container.getEnchantment(UniqueEnchantments.CLOUD_WALKER, EntityEquipmentSlot.FEET)) > 0) {
            NBTTagCompound nbt = player.getEntityData();
            if (player.func_70093_af() && !nbt.func_74767_n("cloud_trigger") && (!player.field_70122_E || nbt.func_74767_n("cloud_enabled"))) {
                nbt.func_74757_a("cloud_enabled", !nbt.func_74767_n("cloud_enabled"));
                nbt.func_74757_a("cloud_trigger", true);
            } else if (!player.func_70093_af()) {
                nbt.func_74757_a("cloud_trigger", false);
            }
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (nbt.func_74767_n("cloud_enabled")) {
                int value = StackUtils.getInt((ItemStack)stack, (String)"cloud", (int)(Cloudwalker.TICKS.get(level) * 5));
                if (value <= 0) {
                    nbt.func_74757_a("cloud_enabled", false);
                    return;
                }
                player.field_70181_x = player.field_71075_bZ.field_75100_b ? 0.15 : 0.0;
                player.func_180430_e(player.field_70143_R, 1.0f);
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
                if (!player.func_184812_l_()) {
                    boolean levi = player.func_70644_a(MobEffects.field_188424_y);
                    int leviLevel = levi ? player.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1 : 0;
                    StackUtils.setInt((ItemStack)stack, (String)"cloud", (int)(value - Math.max(1, 5 - leviLevel * 2)));
                    if (player.field_70170_p.func_82737_E() % (long)Math.max(1, (int)(20.0 * (Math.sqrt(level) / (double)(leviLevel + 1)))) == 0L) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                }
            } else {
                StackUtils.setInt((ItemStack)stack, (String)"cloud", (int)(Cloudwalker.TICKS.get(level) * 5));
            }
        }
        Boolean cache = null;
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor((Enchantment)UniqueEnchantments.ECOLOGICAL);
        for (int i = 0; i < slots.length; ++i) {
            level = container.getEnchantment(UniqueEnchantments.ECOLOGICAL, slots[i]);
            ItemStack equipStack = player.func_184582_a(slots[i]);
            if (level <= 0 || !equipStack.func_77951_h() || player.field_70170_p.func_82737_E() % (long)Math.max(1, (int)((double)Ecological.SPEED.get() / Math.log10(10.0 + (double)(player.field_71068_ca * level) / Ecological.SPEED_SCALE.get()))) != 0L || !(cache == null ? (cache = Boolean.valueOf(StackUtils.hasBlockCount((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (int)1, Ecological.STATES) > 0)) != false : cache != false)) continue;
            equipStack.func_77972_a(-1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onItemDespawn(ItemExpireEvent event) {
        if (MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.GRIMOIRE, (ItemStack)event.getEntityItem().func_92059_d()) > 0) {
            event.setExtraLife(10000);
        }
    }

    @SubscribeEvent
    public void onXPPickup(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ObjectArrayList all = new ObjectArrayList();
        ObjectArrayList ender = new ObjectArrayList();
        EntityEquipmentSlot[] slots = MiscUtil.getEquipmentSlotsFor((Enchantment)UniqueEnchantments.ENDER_MENDING);
        for (int i2 = 0; i2 < slots.length; ++i2) {
            ItemStack stack2 = player.func_184582_a(slots[i2]);
            if (stack2.func_190926_b()) continue;
            int level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ENDER_MENDING, (ItemStack)stack2);
            if (level > 0) {
                all.add(stack2);
                ender.add(stack2);
                continue;
            }
            if (!stack2.func_77951_h() || MiscUtil.getEnchantmentLevel((Enchantment)Enchantments.field_185296_A, (ItemStack)stack2) <= 0) continue;
            all.add(stack2);
        }
        if (ender.size() <= 0) {
            return;
        }
        EntityXPOrb orb = event.getOrb();
        int xp = orb.field_70530_e;
        int totalXP = xp * 2;
        int usedXP = 0;
        if ((usedXP += StackUtils.evenDistribute((int)totalXP, (Random)orb.field_70170_p.field_73012_v, (List)all, (stack, i) -> {
            int used = Math.min(i, stack.func_77952_i());
            stack.func_77964_b(stack.func_77952_i() - used);
            return used;
        })) >= totalXP) {
            orb.field_70530_e = 0;
            player.func_71001_a((Entity)orb, 1);
            orb.func_70106_y();
            event.setCanceled(true);
            return;
        }
        usedXP += StackUtils.evenDistribute((int)(totalXP - usedXP), (Random)orb.field_70170_p.field_73012_v, (List)ender, (stack, i) -> {
            int max = MathHelper.func_76143_f((double)((double)EnderMending.LIMIT.get() * Math.pow(EnderMending.LIMIT_MULTIPLIER.get(), Math.sqrt(MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ENDER_MENDING, (ItemStack)stack)))));
            int stored = StackUtils.getInt((ItemStack)stack, (String)"ender_mending", (int)0);
            int left = Math.min(i, max - stored);
            StackUtils.setInt((ItemStack)stack, (String)"ender_mending", (int)(stored + left));
            return left;
        });
        int left = (totalXP - usedXP) / 2;
        player.func_71001_a((Entity)event.getOrb(), 1);
        event.getOrb().func_70106_y();
        event.setCanceled(true);
        if (left > 0) {
            player.func_71023_q(left);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        double value;
        if (event.getEntityPlayer() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184614_ca();
        Object2IntMap ench = MiscUtil.getEnchantments((ItemStack)held);
        int level = ench.getInt((Object)UniqueEnchantments.MOMENTUM);
        if (level > 0 && this.isMining(player)) {
            NBTTagCompound nbt = player.getEntityData();
            long worldTime = player.field_70170_p.func_82737_E();
            long time = nbt.func_74763_f("last_mined");
            double count = nbt.func_74769_h("mined");
            if (worldTime - time > (long)Momentum.MAX_DELAY.get() || worldTime < time) {
                count = 0.0;
                nbt.func_74780_a("mined", 0.0);
                if (!player.field_70170_p.field_72995_K) {
                    UniqueEnchantmentsBase.NETWORKING.sendToPlayer((IUEPacket)new EntityPacket(player.func_145782_y(), nbt), player);
                }
            }
            double flat = Math.log(1.0 + Momentum.SPEED.get(count) / Math.pow(1.0f + event.getNewSpeed(), 0.25));
            double percent = 1.0 + Math.pow(Momentum.SPEED_MULTIPLIER.get(count), 0.55f) / (double)level;
            event.setNewSpeed((float)(((double)event.getNewSpeed() + flat) * percent));
            nbt.func_74772_a("last_mined", worldTime);
        }
        if ((level = ench.getInt((Object)UniqueEnchantments.RANGE)) > 0 && (value = MiscUtil.getBaseAttribute((EntityLivingBase)player, (IAttribute)EntityPlayer.REACH_DISTANCE)) * value < player.func_174831_c(event.getPos())) {
            event.setNewSpeed(event.getNewSpeed() * Range.REDUCTION.getLogDevided(level + 1));
        }
    }

    public boolean isMining(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            return (Boolean)ReflectionHelper.getPrivateValue(PlayerInteractionManager.class, (Object)((EntityPlayerMP)player).field_71134_c, (String)"isDestroyingBlock", (String)"field_73088_d");
        }
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack held = event.getPlayer().func_184614_ca();
        Object2IntMap enchs = MiscUtil.getEnchantments((ItemStack)held);
        int level = enchs.getInt((Object)UniqueEnchantments.ALCHEMISTS_GRACE);
        if (level > 0) {
            AlchemistsGrace.applyToEntity((Entity)event.getPlayer(), true, event.getState().func_185887_b(event.getWorld(), event.getPos()));
        }
        if ((level = enchs.getInt((Object)UniqueEnchantments.SMART_ASS)) > 0 && !BREAKING.get().booleanValue() && SmartAss.VALID_STATES.test(event.getState())) {
            Block block = event.getState().func_177230_c();
            int limit = SmartAss.RANGE.get(level);
            World world = event.getWorld();
            IBlockState lastState = null;
            BlockPos lastPos = null;
            for (int i = 1; i < limit; ++i) {
                BlockPos pos = event.getPos().func_177981_b(i);
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() != block) continue;
                lastState = state;
                lastPos = pos;
            }
            BREAKING.set(true);
            if (lastState != null && MiscUtil.harvestBlock((BlockEvent.BreakEvent)event, lastState, lastPos)) {
                BREAKING.set(false);
                event.setCanceled(true);
                return;
            }
            BREAKING.set(false);
        }
        if ((level = enchs.getInt((Object)UniqueEnchantments.SAGES_BLESSING)) > 0) {
            event.setExpToDrop((int)((double)event.getExpToDrop() + (double)event.getExpToDrop() * SagesBlessing.XP_BOOST.get((double)(level += event.getWorld().field_73012_v.nextInt(enchs.getInt((Object)Enchantments.field_185308_t) + 1)))));
        }
        if ((level = enchs.getInt((Object)UniqueEnchantments.MOMENTUM)) > 0) {
            double cap = (double)Momentum.CAP.get() * Math.pow(Momentum.CAP_MULTIPLIER.get((double)level), 2.0);
            double extra = (double)Math.min(1000.0f, event.getState().func_185887_b(event.getWorld(), event.getPos())) * Math.pow(1 + level * level / 100, 1 + level / 100);
            NBTTagCompound nbt = event.getPlayer().getEntityData();
            nbt.func_74780_a("mined", Math.min(nbt.func_74769_h("mined") + extra, cap));
            UniqueEnchantmentsBase.NETWORKING.sendToPlayer((IUEPacket)new EntityPacket(event.getPlayer().func_145782_y(), nbt), event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onBlockLoot(BlockEvent.HarvestDropsEvent event) {
        int stored;
        int level;
        int gold;
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack stack = event.getHarvester().func_184614_ca();
        Object2IntMap enchs = MiscUtil.getEnchantments((ItemStack)stack);
        int midas = enchs.getInt((Object)UniqueEnchantments.MIDAS_BLESSING);
        if (midas > 0 && (gold = StackUtils.getInt((ItemStack)stack, (String)MidasBlessing.GOLD_COUNTER, (int)0)) > 0 && StackUtils.isGem((IBlockState)event.getState())) {
            StackUtils.setInt((ItemStack)stack, (String)MidasBlessing.GOLD_COUNTER, (int)Math.max(0, gold -= (int)(Math.pow(MidasBlessing.GOLD_COST.getAsDouble((double)midas), 2.0) / (double)midas)));
            int multiplier = 1 + midas;
            ObjectArrayList newDrops = new ObjectArrayList();
            for (ItemStack drop : event.getDrops()) {
                StackUtils.growStack((ItemStack)drop, (int)(drop.func_190916_E() * multiplier), (List)newDrops);
            }
            event.getDrops().clear();
            event.getDrops().addAll(newDrops);
        }
        if ((level = enchs.getInt((Object)UniqueEnchantments.IFRIDS_GRACE)) > 0 && (stored = StackUtils.getInt((ItemStack)stack, (String)IfritsGrace.LAVA_COUNT, (int)0)) > 0) {
            double extra = (double)(level * level / level) + 1.0;
            boolean ore = StackUtils.isOre((IBlockState)event.getState());
            int smelted = 0;
            List stacks = event.getDrops();
            int m = stacks.size();
            for (int i = 0; i < m; ++i) {
                ItemStack toBurn = ((ItemStack)stacks.get(i)).func_77946_l();
                toBurn.func_190920_e(1);
                ItemStack burned = FurnaceRecipes.func_77602_a().func_151395_a(toBurn).func_77946_l();
                if (burned.func_190926_b()) continue;
                burned.func_190920_e(burned.func_190916_E() * ((ItemStack)stacks.get(i)).func_190916_E());
                stacks.set(i, burned);
                ++smelted;
            }
            if (smelted > 0) {
                StackUtils.setInt((ItemStack)stack, (String)IfritsGrace.LAVA_COUNT, (int)Math.max(0, stored -= MathHelper.func_76143_f((double)((double)(smelted * (ore ? 5 : 1)) * IfritsGrace.BASE_CONSUMTION.get() * extra / (double)level))));
            }
        }
    }

    @SubscribeEvent
    public void onItemClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (!event.getWorld().field_72995_K && stack.func_77973_b() instanceof ItemMap && MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ENDER_LIBRARIAN, (ItemStack)stack) > 0) {
            ItemMap map = (ItemMap)stack.func_77973_b();
            MapData data = map.func_77873_a(stack, event.getWorld());
            if (data == null || data.field_76200_c != event.getWorld().field_73011_w.getDimension()) {
                return;
            }
            int x = data.field_76201_a;
            int z = data.field_76199_b;
            BlockPos position = null;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                NBTTagList list = nbt.func_150295_c("Decorations", 10);
                int m = list.func_74745_c();
                for (int i = 0; i < m; ++i) {
                    NBTTagCompound nbtData = list.func_150305_b(i);
                    if (!nbtData.func_74779_i("id").equalsIgnoreCase("+")) continue;
                    position = new BlockPos(nbtData.func_74762_e("x") - 20, 255, nbtData.func_74762_e("z") - 20);
                }
            }
            if (position != null) {
                BlockPos pos = event.getWorld().func_175672_r(position);
                event.getEntityPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            } else {
                int limit = 64 * (1 << data.field_76197_d) * 2;
                int xOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                int zOffset = (int)((event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)limit);
                BlockPos pos = event.getWorld().func_175672_r(new BlockPos(x + xOffset, 255, z + zOffset));
                event.getEntityPlayer().func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)Math.max(event.getWorld().func_181545_F(), pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f));
            }
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void onEntityHit(LivingAttackEvent event) {
        AlchemistsGrace.applyToEntity(event.getSource().func_76346_g(), false, 1.5f);
    }

    @SubscribeEvent
    public void onArmorDamage(LivingHurtEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attr;
            EntityLivingBase base = (EntityLivingBase)entity;
            Object2IntMap enchantments = MiscUtil.getEnchantments((ItemStack)base.func_184614_ca());
            int level = enchantments.getInt((Object)UniqueEnchantments.SWIFT_BLADE);
            if (level > 0 && (attr = base.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
                event.setAmount(event.getAmount() * (float)Math.log10(10.0 + (1.6 + Math.log(Math.max(0.25, attr.func_111126_e())) / SwiftBlade.BASE_SPEED.get()) * MathCache.LOG.get(level * level)));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.FOCUS_IMPACT)) > 0 && (attr = base.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
                event.setAmount(event.getAmount() * (1.0f + (float)Math.log10(Math.pow(FocusImpact.BASE_SPEED.get() / attr.func_111126_e(), 2.0) * MathCache.LOG.get(6 + level))));
            }
            if ((level = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.CLIMATE_TRANQUILITY, (EntityLivingBase)base).getIntValue()) > 0) {
                Set effects = BiomeDictionary.getTypes((Biome)base.field_70170_p.func_180494_b(base.func_180425_c()));
                boolean hasHot = effects.contains(BiomeDictionary.Type.HOT) || effects.contains(BiomeDictionary.Type.NETHER);
                boolean hasCold = effects.contains(BiomeDictionary.Type.COLD);
                if (hasHot && !hasCold) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, ClimateTranquility.SLOW_TIME.get() * level, level));
                } else if (hasCold && !hasHot) {
                    event.getEntityLiving().func_70015_d(level * ClimateTranquility.BURN_TIME.get());
                }
            }
            if (event.getEntityLiving() instanceof AbstractSkeleton && (level = enchantments.getInt((Object)UniqueEnchantments.BONE_CRUSH)) > 0 && BoneCrusher.isNotArmored((AbstractSkeleton)event.getEntityLiving())) {
                event.setAmount((float)((double)event.getAmount() * (1.0 + Math.log10(1.0f + BoneCrusher.BONUS_DAMAGE.getFloat((float)level)))));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.BERSERKER)) > 0) {
                event.setAmount(event.getAmount() * (float)(1.0 + (1.0 - Berserk.MIN_HEALTH.getMax((double)base.func_110143_aJ(), 1.0) / (double)base.func_110138_aP()) * Berserk.PERCENTUAL_DAMAGE.get() * MathCache.LOG10.get(level + 1)));
            }
            if ((level = enchantments.getInt((Object)UniqueEnchantments.PERPETUAL_STRIKE)) > 0) {
                ItemStack held = base.func_184614_ca();
                int count = StackUtils.getInt((ItemStack)held, (String)"strikes", (int)0);
                int lastEntity = StackUtils.getInt((ItemStack)held, (String)"hit_id", (int)0);
                if (lastEntity != event.getEntityLiving().func_145782_y()) {
                    count = 0;
                    StackUtils.setInt((ItemStack)held, (String)"hit_id", (int)event.getEntityLiving().func_145782_y());
                }
                float amount = event.getAmount();
                double damage = (1.0 + Math.pow(PerpetualStrike.PER_HIT.get((double)count) / Math.log(2.8 + MiscUtil.getAttribute((EntityLivingBase)base, (IAttribute)SharedMonsterAttributes.field_188790_f, (double)1.0)), 1.4) - 1.0) * (double)level * PerpetualStrike.PER_HIT_LEVEL.get();
                double multiplier = Math.log10(10.0 + damage / Math.log10(1.0f + event.getAmount()) * PerpetualStrike.MULTIPLIER.get());
                amount = (float)((double)amount + damage);
                amount = (float)((double)amount * multiplier);
                event.setAmount(amount);
                StackUtils.setInt((ItemStack)held, (String)"strikes", (int)(count + 1));
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        NBTTagCompound compound;
        int consume;
        int feathers;
        ItemStack stack;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance attr;
            EntityLivingBase base = (EntityLivingBase)entity;
            level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.SPARTAN_WEAPON, (ItemStack)base.func_184614_ca());
            if (level > 0 && base.func_184592_cb().func_77973_b() instanceof ItemShield && (attr = base.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f)) != null) {
                event.setAmount((float)((double)event.getAmount() * (1.0 + (double)SpartanWeapon.EXTRA_DAMAGE.getFloat() * Math.log((double)(event.getAmount() * event.getAmount()) / attr.func_111126_e()) * (double)level)));
            }
            if ((level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ENDEST_REAP, (ItemStack)base.func_184614_ca())) > 0) {
                event.setAmount(event.getAmount() + (EndestReap.BONUS_DAMAGE_LEVEL.getFloat((float)level) + EndestReap.REAP_MULTIPLIER.getFloat((float)(level * base.getEntityData().func_74775_l("PlayerPersisted").func_74762_e("reap_storage")))));
            }
        }
        if (event.getSource() == DamageSource.field_188406_j && (level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ICARUS_AEGIS, (ItemStack)(stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)))) > 0 && (feathers = StackUtils.getInt((ItemStack)stack, (String)IcarusAegis.FEATHER_TAG, (int)0)) >= (consume = (int)Math.ceil(IcarusAegis.BASE_CONSUMPTION.get() / (double)level))) {
            StackUtils.setInt((ItemStack)stack, (String)IcarusAegis.FEATHER_TAG, (int)(feathers -= consume));
            event.setCanceled(true);
            return;
        }
        if (event.getAmount() >= event.getEntityLiving().func_110143_aJ()) {
            ItemStack stack2;
            int level2;
            DamageSource source = event.getSource();
            if (!source.func_82725_o() && source != DamageSource.field_76379_h && (level2 = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ARES_BLESSING, (ItemStack)(stack2 = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)))) > 0 && stack2.func_77984_f()) {
                float damage = event.getAmount();
                stack2.func_77972_a((int)((double)damage * AresBlessing.BASE_DAMAGE.get() / MathCache.LOG.get(level2 + 1)), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            Object2IntMap.Entry slot = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.PHOENIX_BLESSING, (EntityLivingBase)event.getEntityLiving());
            if (slot.getIntValue() > 0) {
                EntityLivingBase living = event.getEntityLiving();
                living.func_70691_i(living.func_110138_aP());
                living.func_70674_bp();
                if (living instanceof EntityPlayer) {
                    ((EntityPlayer)living).func_71024_bL().func_75122_a(Short.MAX_VALUE, 1.0f);
                }
                living.getEntityData().func_74772_a("curse_regain_timer", living.func_130014_f_().func_82737_E() + (long)DeathsOdium.DELAY.get());
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 2));
                living.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 1));
                living.field_70170_p.func_72960_a((Entity)living, (byte)35);
                event.getEntityLiving().func_184582_a((EntityEquipmentSlot)slot.getKey()).func_190918_g(1);
                event.setCanceled(true);
                for (EntityLivingBase entry : living.func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(living.func_180425_c()).func_186662_g(PhoenixBlessing.RANGE.getAsDouble((double)slot.getIntValue())))) {
                    if (entry == living) continue;
                    entry.func_70015_d(600000);
                }
            }
        }
        if (entity instanceof EntityPlayer && (compound = entity.getEntityData()).func_74763_f("curse_regain_timer") >= entity.field_70170_p.func_82737_E()) {
            compound.func_74776_a("curse_regain_damage", compound.func_74760_g("curse_regain_damage") + event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        int consume;
        int feathers;
        ItemStack stack = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
        int level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ICARUS_AEGIS, (ItemStack)stack);
        if (level > 0 && stack.func_77978_p().func_74767_n(IcarusAegis.FLYING_TAG) && event.getDistance() > 3.0f && (feathers = StackUtils.getInt((ItemStack)stack, (String)IcarusAegis.FEATHER_TAG, (int)0)) >= (consume = (int)(IcarusAegis.BASE_CONSUMPTION.get() / MathCache.LOG.get(2 + level)))) {
            StackUtils.setInt((ItemStack)stack, (String)IcarusAegis.FEATHER_TAG, (int)(feathers -= consume));
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        int maxLevel;
        NBTTagCompound nbt;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            Entity killed;
            ItemStack stack;
            int amount;
            EntityLivingBase base = (EntityLivingBase)entity;
            int level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.WARRIORS_GRACE, (ItemStack)base.func_184614_ca());
            if (level > 0 && (amount = Math.min((stack = base.func_184614_ca()).func_77952_i(), MathHelper.func_76143_f((double)(Math.sqrt(event.getEntityLiving().func_110138_aP() * (float)level) * WarriorsGrace.DURABILITY_GAIN.get())))) > 0) {
                stack.func_77972_a(-amount, base);
            }
            if ((killed = event.getEntity()) != null && base instanceof EntityPlayer && (amount = EndestReap.isValid(killed)) > 0 && (level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.ENDEST_REAP, (ItemStack)base.func_184614_ca())) > 0) {
                nbt = MiscUtil.getPersistentData((Entity)entity);
                int result = Math.min(nbt.func_74762_e("reap_storage") + amount, ((EntityPlayer)base).field_71068_ca);
                nbt.func_74768_a("reap_storage", result);
                StackUtils.setInt((ItemStack)base.func_184614_ca(), (String)"reap_storage", (int)result);
            }
        }
        if ((maxLevel = MiscUtil.getCombinedEnchantmentLevel((Enchantment)UniqueEnchantments.DEATHS_ODIUM, (EntityLivingBase)event.getEntityLiving())) > 0) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                int newValue;
                int value;
                ItemStack stack = event.getEntityLiving().func_184582_a(slot);
                if (MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.DEATHS_ODIUM, (ItemStack)stack) <= 0 || (value = StackUtils.getInt((ItemStack)stack, (String)"curse_storage", (int)0)) == (newValue = Math.min(value + 1, DeathsOdium.MAX_STORAGE.get(maxLevel)))) continue;
                StackUtils.setInt((ItemStack)stack, (String)"curse_storage", (int)newValue);
                break;
            }
            IAttributeInstance instance = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier mod = instance.func_111127_a(DeathsOdium.REMOVE_UUID);
            float toRemove = 0.0f;
            if (mod != null) {
                toRemove = (float)((double)toRemove + mod.func_111164_d());
                instance.func_111124_b(mod);
            }
            if ((nbt = event.getEntityLiving().getEntityData().func_74775_l("PlayerPersisted")).func_74767_n("curse_reset")) {
                nbt.func_82580_o("curse_reset");
                nbt.func_82580_o("curse_storage");
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    ItemStack stack = event.getEntityLiving().func_184582_a(slot);
                    if (MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.DEATHS_ODIUM, (ItemStack)stack) <= 0) continue;
                    stack.func_77978_p().func_82580_o("curse_storage");
                }
                return;
            }
            event.getEntityLiving().getEntityData().func_74782_a("PlayerPersisted", (NBTBase)nbt);
            nbt.func_74776_a("curse_storage", toRemove - (float)Math.ceil(Math.sqrt(DeathsOdium.BASE_LOSS.get((double)maxLevel))));
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        float f = event.getEntityPlayer().getEntityData().func_74775_l("PlayerPersisted").func_74760_g("curse_storage");
        if (f != 0.0f) {
            event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(DeathsOdium.REMOVE_UUID, "odiums_curse", (double)f, 0));
        }
    }

    @SubscribeEvent
    public void onEaten(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().func_77973_b() == Items.field_151106_aX && MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.DEATHS_ODIUM, (ItemStack)event.getItem()) > 0) {
            event.getEntityLiving().getEntityData().func_74775_l("PlayerPersisted").func_74757_a("curse_reset", true);
            event.getEntityLiving().func_174812_G();
        }
    }

    @SubscribeEvent
    public void onXPDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        Object2IntMap.Entry slot = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.SAGES_BLESSING, (EntityLivingBase)event.getAttackingPlayer());
        int level = slot.getIntValue();
        if (level > 0) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() + (double)event.getDroppedExperience() * SagesBlessing.XP_BOOST.get((double)(level += event.getAttackingPlayer().field_70170_p.field_73012_v.nextInt(MiscUtil.getEnchantmentLevel((Enchantment)Enchantments.field_185304_p, (ItemStack)event.getAttackingPlayer().func_184582_a((EntityEquipmentSlot)slot.getKey())) + 1)))));
        }
    }

    @SubscribeEvent
    public void onLootingLevel(LootingLevelEvent event) {
        int level;
        if (event.getDamageSource() == null) {
            return;
        }
        Entity entity = event.getDamageSource().func_76346_g();
        if (entity instanceof EntityLivingBase && event.getEntityLiving() instanceof AbstractSkeleton && (level = MiscUtil.getEnchantmentLevel((Enchantment)UniqueEnchantments.BONE_CRUSH, (ItemStack)((EntityLivingBase)entity).func_184614_ca())) > 0 && BoneCrusher.isNotArmored((AbstractSkeleton)event.getEntityLiving())) {
            event.setLootingLevel(event.getLootingLevel() + 1 + level);
        }
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        EntityPlayer base;
        Object2IntMap.Entry slot;
        int level;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityPlayer && event.getEntityLiving() instanceof EntityAnimal && (level = (slot = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.FAST_FOOD, (EntityLivingBase)(base = (EntityPlayer)entity))).getIntValue()) > 0) {
            int looting = base.field_70170_p.field_73012_v.nextInt(1 + MiscUtil.getEnchantmentLevel((Enchantment)Enchantments.field_185304_p, (ItemStack)base.func_184582_a((EntityEquipmentSlot)slot.getKey())));
            int burning = event.getEntityLiving().func_70027_ad() ? 2 : 1;
            base.func_71024_bL().func_75122_a(FastFood.NURISHMENT.get((level *= base.field_70170_p.field_73012_v.nextInt(MiscUtil.getEnchantmentLevel((Enchantment)Enchantments.field_185304_p, (ItemStack)base.func_184582_a((EntityEquipmentSlot)slot.getKey())) + 1) + 1) + looting) * burning, FastFood.SATURATION.getFloat((float)(level + looting)) * (float)burning);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowHit(ProjectileImpactEvent.Arrow event) {
        EntityPlayer player;
        Object2IntMap.Entry slot;
        RayTraceResult result = event.getRayTraceResult();
        if (result.field_72313_a != RayTraceResult.Type.ENTITY || !(result.field_72308_g instanceof EntityLivingBase) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityArrow arrow = event.getArrow();
        AlchemistsGrace.applyToEntity(arrow.field_70250_c, false, 1.5f);
        if (arrow.field_70250_c instanceof EntityPlayer && (slot = MiscUtil.getEnchantedItem((Enchantment)UniqueEnchantments.ENDERMARKSMEN, (EntityLivingBase)(player = (EntityPlayer)arrow.field_70250_c))).getIntValue() > 0) {
            int level = slot.getIntValue();
            ItemStack stack = player.func_184582_a((EntityEquipmentSlot)slot.getKey());
            arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
            player.func_191521_c(StackUtils.getArrowStack((EntityArrow)arrow));
            int needed = Math.min(MathHelper.func_76128_c((double)(MathCache.LOG_ADD.get(level) * EnderMarksmen.EXTRA_DURABILITY.get())), stack.func_77952_i());
            if (needed > 0) {
                stack.func_77972_a(-needed, (EntityLivingBase)player);
            }
            if (result.field_72308_g instanceof EntityEnderman) {
                ENDERMEN_TO_BLOCK.set(result.field_72308_g.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void onEndermenTeleport(EnderTeleportEvent event) {
        UUID id = ENDERMEN_TO_BLOCK.get();
        if (event.getEntity().func_110124_au().equals(id)) {
            ENDERMEN_TO_BLOCK.set(null);
            event.setCanceled(true);
            return;
        }
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityEnderman) {
            double distance = MiscUtil.getAttribute((EntityLivingBase)living, (IAttribute)SharedMonsterAttributes.field_111265_b, (double)16.0);
            if (living.func_130014_f_().func_184150_a(living.field_70165_t, living.field_70163_u, living.field_70161_v, distance, distance, null, EnderEyes.getPlayerFilter(living)) != null) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEquippementSwapped(LivingEquipmentChangeEvent event) {
        AbstractAttributeMap attribute = event.getEntityLiving().func_110140_aT();
        Multimap<String, AttributeModifier> mods = this.createModifiersFromStack(event.getFrom(), event.getEntityLiving(), event.getSlot());
        if (!mods.isEmpty()) {
            attribute.func_111148_a(mods);
        }
        if (!(mods = this.createModifiersFromStack(event.getTo(), event.getEntityLiving(), event.getSlot())).isEmpty()) {
            attribute.func_111147_b(mods);
        }
    }

    private Multimap<String, AttributeModifier> createModifiersFromStack(ItemStack stack, EntityLivingBase living, EntityEquipmentSlot slot) {
        int value;
        HashMultimap mods = HashMultimap.create();
        Object2IntMap enchantments = MiscUtil.getEnchantments((ItemStack)stack);
        int level = enchantments.getInt((Object)UniqueEnchantments.VITAE);
        if (level > 0 && MiscUtil.getSlotsFor((Enchantment)UniqueEnchantments.VITAE).contains(slot)) {
            int xpLevel = living instanceof EntityPlayer ? ((EntityPlayer)living).field_71068_ca : 100;
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(Vitae.HEALTH_MOD.getId(slot), "Vitae Boost", Math.log10((double)(100 + Vitae.BASE_BOOST.get(level)) + Math.sqrt(Vitae.SCALE_BOOST.get((double)xpLevel))) - 2.0, 2));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.SWIFT)) > 0 && MiscUtil.getSlotsFor((Enchantment)UniqueEnchantments.SWIFT).contains(slot)) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Swift.SPEED_MOD, "Swift Boost", Swift.SPEED_BONUS.getAsDouble((double)level), 2));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.RANGE)) > 0 && MiscUtil.getSlotsFor((Enchantment)UniqueEnchantments.RANGE).contains(slot)) {
            mods.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(Range.RANGE_MOD, "Range Boost", (double)Range.RANGE.getAsFloat((float)level), 0));
        }
        if ((level = enchantments.getInt((Object)UniqueEnchantments.DEATHS_ODIUM)) > 0 && MiscUtil.getSlotsFor((Enchantment)UniqueEnchantments.DEATHS_ODIUM).contains(slot) && (value = StackUtils.getInt((ItemStack)stack, (String)"curse_storage", (int)0)) > 0) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(DeathsOdium.GENERAL_MOD.getId(slot), "Death Odiums Restore", DeathsOdium.BASE_LOSS.get((double)value), 0));
        }
        return mods;
    }
}

