/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class WizardTradeTweaksHandler {
    private static final ResourceLocation NEW_SPELL_ICON = new ResourceLocation("ebwizardry", "textures/gui/container/new_spell_indicator.png");
    private static final int ICON_WIDTH = 8;
    private static final int ICON_HEIGHT = 8;
    private static final int ANIMATION_FRAMES = 4;
    private static final int ANIMATION_FRAME_TIME = 2;
    private static final int ANIMATION_PERIOD = 40;
    private static int tradeIndex;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMerchant) {
            tradeIndex = 0;
        }
    }

    @SubscribeEvent
    public static void onActionPerformedPostEvent(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiMerchant) {
            MerchantRecipeList recipes = ((GuiMerchant)event.getGui()).func_147035_g().func_70934_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (recipes == null) {
                return;
            }
            if (event.getButton().field_146127_k == 1) {
                tradeIndex = Math.min(tradeIndex + 1, recipes.size());
            } else if (event.getButton().field_146127_k == 2) {
                tradeIndex = Math.max(tradeIndex - 1, 0);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof GuiMerchant) {
            MerchantRecipe recipe;
            GuiMerchant gui = (GuiMerchant)event.getGuiContainer();
            MerchantRecipeList trades = gui.func_147035_g().func_70934_b((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (trades == null) {
                return;
            }
            if (gui.field_147002_h.func_75139_a(0).func_75211_c().func_77973_b() == WizardryItems.spell_book || gui.field_147002_h.func_75139_a(1).func_75211_c().func_77973_b() == WizardryItems.spell_book) {
                for (MerchantRecipe trade : trades) {
                    if (trade.func_77394_a().func_77973_b() != WizardryItems.spell_book || !trade.func_77396_b().func_190926_b()) continue;
                    Slot slot = gui.field_147002_h.func_75139_a(2);
                    DrawingUtils.drawItemAndTooltip((GuiContainer)gui, trade.func_77397_d(), slot.field_75223_e, slot.field_75221_f, event.getMouseX(), event.getMouseY(), gui.getSlotUnderMouse() == slot);
                }
            }
            if (gui.field_147002_h instanceof ContainerMerchant && tradeIndex < trades.size() && (recipe = (MerchantRecipe)trades.get(tradeIndex)) != null && recipe.func_77397_d().func_77973_b() instanceof ItemSpellBook) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                Spell spell = Spell.byMetadata(recipe.func_77397_d().func_77960_j());
                if (Wizardry.settings.discoveryMode && !player.func_184812_l_() && Wizardry.proxy.shouldDisplayDiscovered(spell, recipe.func_77397_d()) && WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                    int x = gui.field_147002_h.func_75139_a((int)2).field_75223_e + 14;
                    int y = gui.field_147002_h.func_75139_a((int)2).field_75221_f - 17;
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(NEW_SPELL_ICON);
                    int frame = Math.max(player.field_70173_aa / 2 % 40 - 36, 0);
                    DrawingUtils.drawTexturedRect(x, y, 0, frame * 8, 8, 8, 8, 32);
                    RenderHelper.func_74518_a();
                }
            }
        }
    }
}

