/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui.handbook;

import com.google.gson.JsonObject;
import electroblob.wizardry.client.gui.handbook.GuiButtonHyperlink;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import electroblob.wizardry.client.gui.handbook.Section;
import electroblob.wizardry.util.JavaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.JsonUtils;

class Contents {
    final String id;
    final Section section;
    private boolean hyperlinks = true;
    private boolean pageNumbers = true;
    private String separator = ".";
    private int startPage;
    private int startLine;
    private final List<List<GuiButton>> buttons;
    private final List<Section> entries;
    private List<Section> visibleEntries;

    private Contents(String id, Section section) {
        this.id = id;
        this.section = section;
        this.entries = new ArrayList<Section>();
        this.buttons = new ArrayList<List<GuiButton>>();
        this.visibleEntries = new ArrayList<Section>();
    }

    Collection<GuiButton> getButtons() {
        return JavaUtils.flatten(this.buttons);
    }

    void addEntry(Section section) {
        this.entries.add(section);
    }

    void draw(FontRenderer font, int doublePage, int left, int top) {
        int[] visiblePages;
        int i = 0;
        for (List<GuiButton> list : this.buttons) {
            int i1 = i++;
            list.forEach(b -> {
                b.field_146125_m = GuiWizardHandbook.singleToDoublePage(this.startPage + i1) == doublePage;
            });
        }
        if (!this.pageNumbers) {
            return;
        }
        int maxLineNumber = 140 / font.field_78288_b;
        int leftIndex = GuiWizardHandbook.doubleToSinglePage(doublePage, false);
        for (int page : visiblePages = new int[]{leftIndex - this.startPage, leftIndex - this.startPage + 1}) {
            if (page < 0 || page >= this.visibleEntries.size() / maxLineNumber + 1) continue;
            int x = left + (GuiWizardHandbook.isRightPage(this.startPage + page) ? 151 : 17);
            int y = top + 16 + this.startLine * font.field_78288_b;
            for (Section entry : this.visibleEntries) {
                if (!entry.isUnlocked()) continue;
                int nameWidth = font.func_78256_a(entry.title);
                String dotsAndNumber = " " + entry.startPage;
                while (font.func_78256_a(dotsAndNumber) < 120 - nameWidth - 2) {
                    dotsAndNumber = this.separator + dotsAndNumber;
                }
                font.func_175065_a(dotsAndNumber, (float)(x + 120 - font.func_78256_a(dotsAndNumber)), (float)y, 1, false);
                if (!this.hyperlinks) {
                    font.func_175065_a(entry.title, (float)x, (float)y, 1, false);
                }
                y += font.field_78288_b;
            }
        }
    }

    int format(FontRenderer font, int startPage, int startLine, int left, int top) {
        this.buttons.clear();
        this.visibleEntries = new ArrayList<Section>(this.entries);
        this.visibleEntries.removeIf(s -> !s.isUnlocked());
        if (this.hyperlinks) {
            int maxLineNumber = 140 / font.field_78288_b;
            this.startPage = startPage;
            this.startLine = startLine;
            ArrayList<GuiButtonHyperlink.Internal> list = new ArrayList<GuiButtonHyperlink.Internal>(maxLineNumber);
            for (Section entry : this.visibleEntries) {
                int x = GuiWizardHandbook.isRightPage(startPage) ? left + 288 - 17 - 120 : left + 17;
                int y = top + 16 + startLine * font.field_78288_b;
                list.add(new GuiButtonHyperlink.Internal(0, x, y, font, entry.title, entry, 0, "", maxLineNumber - startLine, GuiWizardHandbook.isRightPage(startPage), false));
                if (++startLine != maxLineNumber) continue;
                startLine = 0;
                ++startPage;
                this.buttons.add(list);
                list = new ArrayList(maxLineNumber);
            }
            this.buttons.add(list);
        }
        return this.visibleEntries.size();
    }

    static Contents fromJson(Section parent, JsonObject json) {
        Contents contents = new Contents(JsonUtils.func_151200_h((JsonObject)json, (String)"id"), parent);
        contents.hyperlinks = JsonUtils.func_151209_a((JsonObject)json, (String)"hyperlinks", (boolean)true);
        contents.pageNumbers = JsonUtils.func_151209_a((JsonObject)json, (String)"page_numbers", (boolean)true);
        contents.separator = JsonUtils.func_151219_a((JsonObject)json, (String)"separator", (String)".");
        return contents;
    }
}

