/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityStormcloud
extends EntityScaledConstruct {
    public EntityStormcloud(World world) {
        super(world);
        this.func_70105_a(Spells.stormcloud.getProperty("effect_radius").floatValue() * 2.0f, 2.0f);
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_70091_d(MoverType.SELF, this.field_70159_w, 0.0, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            float areaFactor = this.field_70130_N * this.field_70130_N / 36.0f;
            int i = 0;
            while ((float)i < 2.0f * areaFactor) {
                ParticleBuilder.create(ParticleBuilder.Type.CLOUD, this).clr(0.3f, 0.3f, 0.3f).shaded(true).spawn(this.field_70170_p);
                ++i;
            }
        }
        boolean stormcloudRingActive = this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)this.getCaster(), WizardryItems.ring_stormcloud);
        List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72321_a(0.0, -10.0, 0.0));
        targets.removeIf(t -> !this.isValidTarget((Entity)t));
        float damage = Spells.stormcloud.getProperty("damage").floatValue() * this.damageMultiplier;
        for (EntityLivingBase target : targets) {
            if (target.field_70173_aa % 150 != 0) continue;
            if (!this.field_70170_p.field_72995_K) {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.SHOCK), damage);
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(target.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), target.field_70161_v).target((Entity)target).scale(2.0f).spawn(this.field_70170_p);
                ParticleBuilder.spawnShockParticles(this.field_70170_p, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O, target.field_70161_v);
            }
            target.func_184185_a(WizardrySounds.ENTITY_STORMCLOUD_THUNDER, 1.0f, 1.6f);
            target.func_184185_a(WizardrySounds.ENTITY_STORMCLOUD_ATTACK, 1.0f, 1.0f);
            if (!stormcloudRingActive) continue;
            this.lifetime -= 40;
        }
        if (stormcloudRingActive) {
            EntityUtils.getLivingWithinRadius(this.field_70130_N * 3.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p).stream().filter(this::isValidTarget).min(Comparator.comparingDouble(arg_0 -> ((EntityStormcloud)this).func_70068_e(arg_0))).ifPresent(e -> {
                Vec3d vel = e.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.2);
                this.field_70159_w = vel.field_72450_a;
                this.field_70179_y = vel.field_72449_c;
            });
        }
    }
}

