/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;

public final class WizardryBaublesIntegration {
    public static final String BAUBLES_MOD_ID = "baubles";
    private static final Map<ItemArtefact.Type, BaubleType> ARTEFACT_TYPE_MAP = new EnumMap<ItemArtefact.Type, BaubleType>(ItemArtefact.Type.class);
    private static boolean baublesLoaded;

    public static void init() {
        baublesLoaded = Loader.isModLoaded((String)BAUBLES_MOD_ID);
        if (!WizardryBaublesIntegration.enabled()) {
            return;
        }
        ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.RING, BaubleType.RING);
        ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.AMULET, BaubleType.AMULET);
        ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.CHARM, BaubleType.CHARM);
    }

    public static boolean enabled() {
        return Wizardry.settings.baublesIntegration && baublesLoaded;
    }

    public static boolean isBaubleEquipped(EntityPlayer player, Item item) {
        return BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)item) >= 0;
    }

    public static List<ItemArtefact> getEquippedArtefacts(EntityPlayer player, ItemArtefact.Type ... types) {
        ArrayList<ItemArtefact> artefacts = new ArrayList<ItemArtefact>();
        for (ItemArtefact.Type type : types) {
            for (int slot : ARTEFACT_TYPE_MAP.get((Object)type).getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (!(stack.func_77973_b() instanceof ItemArtefact)) continue;
                artefacts.add((ItemArtefact)stack.func_77973_b());
            }
        }
        return artefacts;
    }

    public static final class ArtefactBaubleProvider
    implements ICapabilityProvider {
        private BaubleType type;

        public ArtefactBaubleProvider(ItemArtefact.Type type) {
            this.type = (BaubleType)ARTEFACT_TYPE_MAP.get((Object)type);
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? itemStack -> this.type : null);
        }
    }
}

