/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemManaFlask
extends Item {
    public final Size size;

    public ItemManaFlask(Size size) {
        this.size = size;
        this.func_77637_a(WizardryTabs.WIZARDRY);
        this.func_77625_d(16);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.size.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item.ebwizardry:mana_flask.desc", this.size.capacity);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return this.size.useDuration;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack flask = player.func_184586_b(hand);
        List<ItemStack> stacks = InventoryUtils.getPrioritisedHotbarAndOffhand(player);
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
        if (stacks.stream().anyMatch(s -> s.func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)s.func_77973_b()).isManaFull((ItemStack)s))) {
            if (player.field_71075_bZ.field_75098_d) {
                this.findAndChargeItem(flask, player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)flask);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)flask);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            float f = (float)count / (float)this.func_77626_a(stack);
            Vec3d pos = player.func_174824_e(0.0f).func_178786_a(0.0, 0.2, 0.0).func_178787_e(player.func_70040_Z().func_186678_a(0.6));
            Vec3d delta = new Vec3d(0.0, 0.2 * (double)f, 0.0).func_178789_a((float)count * 0.5f).func_178785_b((float)Math.toRadians(90.0f - player.field_70759_as));
            ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(pos.func_178787_e(delta)).vel(delta.func_186678_a(0.2)).time(12 + player.field_70170_p.field_73012_v.nextInt(6)).clr(1.0f, 1.0f, 0.65f).fade(0.7f, 0.0f, 1.0f).spawn(player.field_70170_p);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.findAndChargeItem(stack, (EntityPlayer)entity);
        }
        return stack;
    }

    private void findAndChargeItem(ItemStack stack, EntityPlayer player) {
        List<ItemStack> stacks = InventoryUtils.getPrioritisedHotbarAndOffhand(player);
        stacks.addAll((Collection<ItemStack>)player.field_71071_by.field_70460_b);
        ItemStack toCharge = stacks.stream().filter(s -> s.func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)s.func_77973_b()).isManaFull((ItemStack)s)).min(Comparator.comparingDouble(s -> ((IManaStoringItem)s.func_77973_b()).getFullness((ItemStack)s))).orElse(null);
        if (toCharge != null) {
            ((IManaStoringItem)toCharge.func_77973_b()).rechargeMana(toCharge, this.size.capacity);
            EntityUtils.playSoundAtPlayer(player, WizardrySounds.ITEM_MANA_FLASK_USE, 1.0f, 1.0f);
            EntityUtils.playSoundAtPlayer(player, WizardrySounds.ITEM_MANA_FLASK_RECHARGE, 0.7f, 1.1f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 20);
        }
    }

    public static enum Size {
        SMALL(75, 25, EnumRarity.COMMON),
        MEDIUM(350, 40, EnumRarity.COMMON),
        LARGE(1400, 60, EnumRarity.RARE);

        public int capacity;
        public int useDuration;
        public EnumRarity rarity;

        private Size(int capacity, int useDuration, EnumRarity rarity) {
            this.capacity = capacity;
            this.useDuration = useDuration;
            this.rarity = rarity;
        }
    }
}

