/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Wizardry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class NBTExtras {
    private NBTExtras() {
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> NBTTagList mapToNBT(Map<K, V> map, Function<K, L> keyFunction, Function<V, W> valueFunction, String keyTagName, String valueTagName) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            NBTTagCompound mapping = new NBTTagCompound();
            NBTExtras.storeTagSafely(mapping, keyTagName, (NBTBase)keyFunction.apply(entry.getKey()));
            NBTExtras.storeTagSafely(mapping, valueTagName, (NBTBase)valueFunction.apply(entry.getValue()));
            tagList.func_74742_a((NBTBase)mapping);
        }
        return tagList;
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> NBTTagList mapToNBT(Map<K, V> map, Function<K, L> keyFunction, Function<V, W> valueFunction) {
        return NBTExtras.mapToNBT(map, keyFunction, valueFunction, "key", "value");
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> Map<K, V> NBTToMap(NBTTagList tagList, Function<L, K> keyFunction, Function<W, V> valueFunction, String keyTagName, String valueTagName) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound mapping = tagList.func_150305_b(i);
            NBTBase keyTag = mapping.func_74781_a(keyTagName);
            NBTBase valueTag = mapping.func_74781_a(valueTagName);
            Object key = null;
            try {
                key = keyFunction.apply(keyTag);
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading map from NBT: unexpected tag type " + NBTBase.field_82578_b[keyTag.func_74732_a()], (Throwable)e);
            }
            Object value = null;
            try {
                value = valueFunction.apply(valueTag);
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading map from NBT: unexpected tag type " + NBTBase.field_82578_b[valueTag.func_74732_a()], (Throwable)e);
            }
            map.put(key, value);
        }
        return map;
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> Map<K, V> NBTToMap(NBTTagList tagList, Function<L, K> keyFunction, Function<W, V> valueFunction) {
        return NBTExtras.NBTToMap(tagList, keyFunction, valueFunction, "key", "value");
    }

    public static <E, T extends NBTBase> NBTTagList listToNBT(Collection<E> list, Function<E, T> mapper) {
        NBTTagList tagList = new NBTTagList();
        for (E element : list) {
            tagList.func_74742_a((NBTBase)mapper.apply(element));
        }
        return tagList;
    }

    public static <E, T extends NBTBase> Collection<E> NBTToList(NBTTagList tagList, Function<T, E> function) {
        ArrayList<E> list = new ArrayList<E>();
        NBTTagList tagList2 = tagList.func_74737_b();
        while (!tagList2.func_82582_d()) {
            NBTBase tag = tagList2.func_74744_a(0);
            try {
                list.add(function.apply(tag));
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading list from NBT: unexpected tag type " + NBTBase.field_82578_b[tag.func_74732_a()], (Throwable)e);
            }
        }
        return list;
    }

    public static void removeUniqueId(NBTTagCompound tag, String key) {
        tag.func_82580_o(key + "Most");
        tag.func_82580_o(key + "Least");
    }

    public static void storeTagSafely(NBTTagCompound compound, String key, NBTBase tag) {
        if (compound == tag || NBTExtras.deepContains(tag, (NBTBase)compound)) {
            Wizardry.logger.error("Cannot store tag of type {} under key '{}' as it would result in a circular reference! Please report this (including your full log) to wizardry's issue tracker.", (Object)NBTBase.func_193581_j((int)tag.func_74732_a()), (Object)key);
        } else {
            compound.func_74782_a(key, tag);
        }
    }

    public static boolean deepContains(NBTBase toSearch, NBTBase searchFor) {
        block3: {
            block2: {
                if (!(toSearch instanceof NBTTagCompound)) break block2;
                for (String subKey : ((NBTTagCompound)toSearch).func_150296_c()) {
                    NBTBase subTag = ((NBTTagCompound)toSearch).func_74781_a(subKey);
                    if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                    return true;
                }
                break block3;
            }
            if (!(toSearch instanceof NBTTagList)) break block3;
            for (NBTBase subTag : (NBTTagList)toSearch) {
                if (subTag != searchFor && !NBTExtras.deepContains(subTag, searchFor)) continue;
                return true;
            }
        }
        return false;
    }
}

