/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.blocks.BlockSonicSecuritySystem;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.entity.camera.EntitySecurityCamera;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.items.ItemUniversalBlockReinforcer;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.PortalSize;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SCWorldListener;
import net.geforcemods.securitycraft.misc.SonicSecuritySystemTracker;
import net.geforcemods.securitycraft.tileentity.IEMPAffected;
import net.geforcemods.securitycraft.tileentity.TileEntityPortableRadar;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntitySonicSecuritySystem;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    public static HashMap<String, String> tipsWithLink = new HashMap();
    private static final Integer NOTE_DELAY = 9;
    public static final Map<EntityPlayer, MutablePair<Integer, Deque<TileEntitySonicSecuritySystem.NoteWrapper>>> PLAYING_TUNES = new HashMap<EntityPlayer, MutablePair<Integer, Deque<TileEntitySonicSecuritySystem.NoteWrapper>>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    if (PlayerUtils.getSelectedItemStack(player, SCContent.portableTunePlayer).func_190926_b()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    TileEntitySonicSecuritySystem.NoteWrapper note = (TileEntitySonicSecuritySystem.NoteWrapper)((Deque)pair.getRight()).poll();
                    if (note != null) {
                        SoundEvent sound = ((BlockNote)Blocks.field_150323_B).func_185576_e(NoteBlockEvent.Instrument.valueOf((String)note.instrumentName.toUpperCase()).ordinal());
                        float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.field_70170_p, player.func_180425_c(), note.noteID, note.instrumentName);
                        pair.setLeft((Object)NOTE_DELAY);
                    } else {
                        pair.setLeft((Object)-1);
                    }
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<EntityPlayer, MutablePair<Integer, Deque<TileEntitySonicSecuritySystem.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ConfigHandler.sayThanksMessage) {
            String tipKey = SCEventHandler.getRandomTip();
            ITextComponent message = new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] ").func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:thanks", SecurityCraft.getVersion())).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:tip", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize(tipKey, new Object[0]));
            if (tipsWithLink.containsKey(tipKey.split("\\.")[2])) {
                message.func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2])));
            }
            event.player.func_145747_a(message);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (player.func_175398_C() instanceof EntitySecurityCamera) {
            EntitySecurityCamera cam = (EntitySecurityCamera)player.func_175398_C();
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v));
            if (tile instanceof TileEntitySecurityCamera) {
                ((TileEntitySecurityCamera)tile).stopViewing();
            }
            cam.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            world.func_184133_a(null, entity.func_180425_c(), SCSounds.ELECTRIFIED.event, SoundCategory.BLOCKS, 0.25f, 1.0f);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && PlayerUtils.isPlayerMountedOnCamera(entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ((EntitySecurityCamera)player.func_175398_C()).stopViewing(player);
        }
    }

    @SubscribeEvent
    public static void onBucketUsed(FillBucketEvent event) {
        ItemStack result;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        World world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getTarget().func_178782_a()).func_177230_c();
        if (block == SCContent.fakeWater) {
            result = new ItemStack(SCContent.fWaterBucket, 1);
        } else if (block == SCContent.fakeLava) {
            result = new ItemStack(SCContent.fLavaBucket, 1);
        } else {
            return;
        }
        world.func_175698_g(pos);
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!stack.func_190926_b() && item != SCContent.universalBlockRemover && item != SCContent.universalBlockModifier && item != SCContent.universalOwnerChanger && !(item instanceof ItemBlock)) {
            boolean isKeypadDoor;
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            boolean bl = isKeypadDoor = block == SCContent.keypadDoor;
            if (item == SCContent.codebreaker && isKeypadDoor) {
                return;
            }
            if (isKeypadDoor || block == SCContent.reinforcedDoor || block == SCContent.reinforcedIronTrapdoor || block == SCContent.scannerDoor) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(event.getPos());
        Block block = world.func_180495_p(event.getPos()).func_177230_c();
        if (te instanceof ILockable && ((ILockable)te).isLocked() && ((ILockable)te).disableInteractionWhenLocked(world, event.getPos(), event.getEntityPlayer())) {
            if (event.getHand() == EnumHand.MAIN_HAND) {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", Utils.localize(block, new Object[0])), TextFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (event.getItemStack().func_77973_b() == Items.field_151137_ax && te instanceof IEMPAffected && ((IEMPAffected)te).isShutDown()) {
            ((IEMPAffected)te).reactivate();
            if (!event.getEntityPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.keyPanel, event.getHand())) {
            for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                if (pc.getOriginalBlock() != block) continue;
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.ALLOW);
            }
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.codebreaker, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.universalBlockModifier, event.getHand()) && te instanceof IModuleInventory) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(event.getEntityPlayer())) {
                if (!(te.func_145838_q() instanceof BlockDisguisable) || ((ItemBlock)((BlockDisguisable)te.func_145838_q()).getDisguisedStack((IBlockAccess)world, event.getPos()).func_77973_b()).func_179223_d() instanceof BlockDisguisable) {
                    PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize("item.securitycraft:universalBlockModifier.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner().getName())), TextFormatting.RED);
                }
                return;
            }
            event.getEntityPlayer().openGui((Object)SecurityCraft.instance, 100, world, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            return;
        }
        if (te instanceof INameSetter && (te instanceof TileEntitySecurityCamera || te instanceof TileEntityPortableRadar) && PlayerUtils.isHoldingItem(event.getEntityPlayer(), Items.field_151057_cb, event.getHand()) && event.getEntityPlayer().func_184586_b(event.getHand()).func_82837_s()) {
            ItemStack nametag = event.getEntityPlayer().func_184586_b(event.getHand());
            INameSetter nameable = (INameSetter)te;
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (nameable.func_70005_c_().equals(nametag.func_82833_r())) {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", nameable.func_145748_c_()), TextFormatting.RED);
                return;
            }
            if (!event.getEntityPlayer().func_184812_l_()) {
                nametag.func_190918_g(1);
            }
            if (!world.field_72995_K) {
                nameable.setCustomName(nametag.func_82833_r());
            }
            PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.named", nameable.func_145748_c_()), TextFormatting.GREEN);
            return;
        }
        List sentries = world.func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()));
        if (!sentries.isEmpty()) {
            event.setCanceled(((EntitySentry)((Object)sentries.get(0))).func_184645_a(event.getEntityPlayer(), event.getHand()));
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        Item held = stack.func_77973_b();
        if (held == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3) {
            ItemUniversalBlockReinforcer.convertBlock(stack, event.getPos(), event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        ItemStack disguiseModule;
        Block block;
        List sentries;
        if (!event.getWorld().field_72995_K) {
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            if (world.func_175625_s(pos) instanceof IModuleInventory) {
                IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
                int i = 100;
                while (i - 100 < te.getMaxNumberOfModules()) {
                    if (!te.getStackInSlot(i).func_190926_b()) {
                        ItemStack stack = te.getStackInSlot(i);
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                        WorldUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)item));
                        te.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModuleType());
                        if (te instanceof TileEntityLinkable) {
                            ((TileEntityLinkable)te).createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModuleType()}, (TileEntityLinkable)te);
                        }
                        if (te instanceof TileEntitySecurityCamera) {
                            TileEntitySecurityCamera cam = (TileEntitySecurityCamera)te;
                            cam.func_145831_w().func_175685_c(cam.func_174877_v().func_177967_a((EnumFacing)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c(), true);
                        }
                    }
                    ++i;
                }
            }
        }
        if (!(sentries = event.getWorld().func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()))).isEmpty() && !((EntitySentry)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (block = ((ItemModule)(disguiseModule = ((EntitySentry)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddon(disguiseModule.func_77978_p())) == event.getWorld().func_180495_p(event.getPos()).func_177230_c()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("securitycraft")) {
            ConfigManager.sync((String)"securitycraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_70005_c_();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150480_ab && event.getWorld().func_180495_p(event.getPos().func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian) {
            PortalSize portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
            if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                portalSize.placePortalBlocks();
            } else {
                portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z);
                if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                    portalSize.placePortalBlocks();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getEntity().func_180425_c();
            do {
                Object portalSize;
                if (event.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.X);
                    if (portalSize.func_150860_b()) {
                        double y = (double)pos.func_177956_o() + 0.5;
                        if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                            y -= 3.0;
                        }
                        event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                        break;
                    }
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.Z);
                    if (!portalSize.func_150860_b()) continue;
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                if (event.getWorld().func_180495_p(pos).func_177230_c() != SCContent.reinforcedObsidian) continue;
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.X);
                if (((PortalSize)portalSize).isValid()) {
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.Z);
                if (!((PortalSize)portalSize).isValid()) continue;
                double y = (double)pos.func_177956_o() + 0.5;
                if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                    y -= 3.0;
                }
                event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                break;
            } while ((pos = pos.func_177984_a()).func_177956_o() < Math.min(event.getWorld().func_72800_K(), 256));
        }
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150427_aO) {
            PortalSize portalSize;
            EnumFacing.Axis axis = (EnumFacing.Axis)event.getState().func_177229_b((IProperty)BlockPortal.field_176550_a);
            if (axis == EnumFacing.Axis.X) {
                PortalSize portalSize2 = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
                if (portalSize2.isValid() || portalSize2.getPortalBlockCount() > portalSize2.getWidth() * portalSize2.getHeight()) {
                    event.setCanceled(true);
                }
            } else if (axis == EnumFacing.Axis.Z && ((portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z)).isValid() || portalSize.getPortalBlockCount() > portalSize.getWidth() * portalSize.getHeight())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (event.getTarget() instanceof EntitySentry) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new SCWorldListener());
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer()) && event.getItemStack().func_77973_b() != SCContent.cameraMonitor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof EntityWither && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote(event.getWorld(), event.getPos(), event.getVanillaNoteId(), event.getInstrument().name());
    }

    private static void handlePlayedNote(World world, BlockPos pos, int vanillaNoteId, String instrumentName) {
        List<TileEntitySonicSecuritySystem> sonicSecuritySystems = SonicSecuritySystemTracker.getSonicSecuritySystemsInRange(world, pos);
        for (TileEntitySonicSecuritySystem te : sonicSecuritySystems) {
            if (!te.isActive()) continue;
            if (te.isRecording()) {
                te.recordNote(vanillaNoteId, instrumentName);
                continue;
            }
            if (!te.listenToNote(vanillaNoteId, instrumentName)) continue;
            te.correctTuneWasPlayed = true;
            te.powerCooldown = (Integer)te.signalLength.get();
            if (!te.hasModule(EnumModuleType.REDSTONE)) continue;
            world.func_175656_a(te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177226_a((IProperty)BlockSonicSecuritySystem.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(world, te.func_174877_v(), SCContent.sonicSecuritySystem, EnumFacing.DOWN);
        }
    }

    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getEntityPlayer().field_70170_p;
        TileEntity tileEntity = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos());
        if (tileEntity instanceof IPasswordProtected && ((IPasswordProtected)tileEntity).isCodebreakable()) {
            if (ConfigHandler.allowCodebreakerItem) {
                if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.codebreaker) {
                    event.getEntityPlayer().func_184586_b(event.getHand()).func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                }
                if (event.getEntityPlayer().func_184812_l_() || new Random().nextInt(3) == 1) {
                    return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getEntityPlayer());
                }
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize("item.securitycraft:codebreaker.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                return true;
            }
            Block block = world.func_180495_p(event.getPos()).func_177230_c();
            PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        }
        return false;
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver", "messages.securitycraft:tip.outdated"};
        return tips[new Random().nextInt(SCEventHandler.isOutdated() ? tips.length : tips.length - 1)];
    }

    private static boolean isOutdated() {
        return ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer()).status == ForgeVersion.Status.OUTDATED;
    }

    static {
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
        tipsWithLink.put("outdated", "https://www.curseforge.com/minecraft/mc-mods/security-craft/files/all");
    }
}

