/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockSpecialDoor
extends BlockDoor
implements ITileEntityProvider {
    public BlockSpecialDoor(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged((IBlockAccess)world, pos, fromPos);
    }

    public void onNeighborChanged(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        World world = (World)access;
        IBlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChanged((IBlockAccess)world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockBelow = pos.func_177984_a();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
                drop = true;
            }
            if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                world.func_175698_g(pos);
                drop = true;
                if (stateBelow.func_177230_c() == this) {
                    world.func_175698_g(blockBelow);
                }
            }
            if (drop && !world.field_72995_K) {
                this.func_176226_b(world, pos, state, 0);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        IBlockState lowerState;
        IBlockState upperState = world.func_180495_p(pos);
        if (!((Boolean)upperState.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
            return;
        }
        if (upperState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            lowerState = upperState;
            pos = pos.func_177984_a();
            upperState = world.func_180495_p(pos);
        } else {
            lowerState = world.func_180495_p(pos.func_177977_b());
        }
        world.func_180501_a(pos, upperState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)), 3);
        world.func_180501_a(pos.func_177977_b(), lowerState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)), 3);
        world.func_180498_a(null, 1011, pos, 0);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getDoorItem());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : this.getDoorItem();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public abstract Item getDoorItem();
}

