/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class WailaDataProvider
implements IWailaDataProvider,
IWailaEntityProvider {
    private static final String SHOW_OWNER = "securitycraft.showowner";
    private static final String SHOW_MODULES = "securitycraft.showmodules";
    private static final String SHOW_PASSWORDS = "securitycraft.showpasswords";
    private static final String SHOW_CUSTOM_NAME = "securitycraft.showcustomname";

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.addConfigRemote("SecurityCraft", SHOW_OWNER, Utils.localize("waila.securitycraft:displayOwner", new Object[0]).func_150254_d());
        registrar.addConfigRemote("SecurityCraft", SHOW_MODULES, Utils.localize("waila.securitycraft:showModules", new Object[0]).func_150254_d());
        registrar.addConfigRemote("SecurityCraft", SHOW_PASSWORDS, Utils.localize("waila.securitycraft:showPasswords", new Object[0]).func_150254_d());
        registrar.addConfigRemote("SecurityCraft", SHOW_CUSTOM_NAME, Utils.localize("waila.securitycraft:showCustomName", new Object[0]).func_150254_d());
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)new WailaDataProvider(), IOverlayDisplay.class);
        registrar.registerBodyProvider((IWailaEntityProvider)new WailaDataProvider(), EntitySentry.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof IOverlayDisplay) {
            return ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> body, IWailaDataAccessor data, IWailaConfigHandler config) {
        IBlockState disguisedBlockState;
        World world = data.getWorld();
        BlockPos pos = data.getPosition();
        IBlockState state = data.getBlockState();
        Block block = data.getBlock();
        boolean disguised = false;
        if (block instanceof BlockDisguisable && (disguisedBlockState = ((BlockDisguisable)block).getDisguisedBlockState((IBlockAccess)world, pos)) != null) {
            disguised = true;
            block = disguisedBlockState.func_177230_c();
        }
        if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(world, state, pos)) {
            return body;
        }
        TileEntity te = data.getTileEntity();
        if (config.getConfig(SHOW_OWNER) && te instanceof IOwnable && block.getRegistryName().func_110624_b().equals("securitycraft")) {
            body.add(Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner().getName())).func_150254_d());
        }
        if (!disguised) {
            if (config.getConfig(SHOW_MODULES) && te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner(data.getPlayer()))) {
                if (!((IModuleInventory)te).getInsertedModules().isEmpty()) {
                    body.add(Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
                }
                for (EnumModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                    body.add("- " + Utils.localize(module.getTranslationKey(), new Object[0]).func_150254_d());
                }
            }
            if (config.getConfig(SHOW_PASSWORDS) && te instanceof IPasswordProtected && !(te instanceof TileEntityKeycardReader) && ((IOwnable)te).getOwner().isOwner(data.getPlayer())) {
                String password = ((IPasswordProtected)te).getPassword();
                body.add(Utils.localize("waila.securitycraft:password", new Object[0]).func_150254_d() + " " + (password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0]).func_150254_d()));
            }
            if (config.getConfig(SHOW_CUSTOM_NAME) && te instanceof IWorldNameable && ((IWorldNameable)te).func_145818_k_()) {
                String name = ((IWorldNameable)te).func_70005_c_();
                body.add(Utils.localize("waila.securitycraft:customName", new Object[0]).func_150254_d() + " " + name);
            }
        }
        return body;
    }

    public List<String> getWailaBody(Entity entity, List<String> body, IWailaEntityAccessor data, IWailaConfigHandler config) {
        if (entity instanceof EntitySentry) {
            EntitySentry sentry = (EntitySentry)entity;
            EntitySentry.EnumSentryMode mode = sentry.getMode();
            if (config.getConfig(SHOW_OWNER)) {
                body.add(Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner().getName())).func_150254_d());
            }
            if (config.getConfig(SHOW_MODULES) && sentry.getOwner().isOwner(data.getPlayer()) && (!sentry.getAllowlistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b() || sentry.hasSpeedModule())) {
                body.add(Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
                if (!sentry.getAllowlistModule().func_190926_b()) {
                    body.add("- " + Utils.localize(EnumModuleType.ALLOWLIST.getTranslationKey(), new Object[0]).func_150254_d());
                }
                if (!sentry.getDisguiseModule().func_190926_b()) {
                    body.add("- " + Utils.localize(EnumModuleType.DISGUISE.getTranslationKey(), new Object[0]).func_150254_d());
                }
                if (sentry.hasSpeedModule()) {
                    body.add("- " + Utils.localize(EnumModuleType.SPEED.getTranslationKey(), new Object[0]).func_150254_d());
                }
            }
            String modeDescription = Utils.localize(mode.getModeKey(), new Object[0]).func_150254_d();
            if (mode != EntitySentry.EnumSentryMode.IDLE) {
                modeDescription = modeDescription + " - " + Utils.localize(mode.getTargetKey(), new Object[0]).func_150254_d();
            }
            body.add(modeDescription);
        }
        return body;
    }

    @SubscribeEvent
    public static void onWailaRender(WailaRenderEvent.Pre event) {
        if (ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    static {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(WailaDataProvider.class);
        }
    }
}

