/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityTrophySystem;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.registry.EntityEntry;
import org.lwjgl.input.Mouse;

public class GuiTrophySystem
extends GuiContainer {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    private final String projectiles = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]).func_150254_d();
    private final String moduleRequired = Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]).func_150254_d();
    private final String toggle = Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]).func_150254_d();
    private final String moddedProjectiles = Utils.localize("gui.securitycraft:trophy_system.moddedProjectiles", new Object[0]).func_150254_d();
    private final boolean isSmart;
    private final List<EntityEntry> orderedFilterList;
    private TileEntityTrophySystem tileEntity;
    private ProjectileScrollList projectileList;

    public GuiTrophySystem(InventoryPlayer inventory, TileEntityTrophySystem te) {
        super((Container)new ContainerGeneric(inventory, te));
        this.tileEntity = te;
        this.isSmart = this.tileEntity.hasModule(EnumModuleType.SMART);
        this.orderedFilterList = new ArrayList<EntityEntry>(this.tileEntity.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == TileEntityTrophySystem.MODDED_PROJECTILES) {
                return 1;
            }
            if (e2 == TileEntityTrophySystem.MODDED_PROJECTILES) {
                return -1;
            }
            return e1.getName().compareTo(e2.getName());
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.projectileList = new ProjectileScrollList(this.field_146297_k, this.field_146999_f - 24, this.field_147000_g - 60, this.field_147009_r + 40, this.field_147003_i + 12, this.field_146294_l, this.field_146295_m);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = Utils.localize("tile.securitycraft:trophy_system.name", new Object[0]).func_150254_d();
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.projectiles, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.projectiles) / 2, 31, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        if (this.projectileList != null) {
            this.projectileList.drawScreen(mouseX, mouseY, partialTicks);
        }
        GuiUtils.renderModuleInfo(EnumModuleType.SMART, this.toggle, this.moduleRequired, this.isSmart, this.field_147003_i + 5, this.field_147009_r + 5, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.projectileList.handleMouseInput(mouseX, mouseY);
    }

    class ProjectileScrollList
    extends GuiScrollingList {
        private int hoveredSlot;

        public ProjectileScrollList(Minecraft client, int width, int height, int top, int left, int screenWidth, int screenHeight) {
            super(client, width, height, top, top + height, left, 12, screenWidth, screenHeight);
            this.hoveredSlot = -1;
        }

        protected int getSize() {
            return GuiTrophySystem.this.orderedFilterList.size();
        }

        protected boolean isSelected(int index) {
            return index == this.hoveredSlot;
        }

        protected void drawBackground() {
        }

        protected int getContentHeight() {
            int height = 50 + this.getSize() * ((GuiTrophySystem)GuiTrophySystem.this).field_146289_q.field_78288_b;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (GuiTrophySystem.this.isSmart) {
                GuiTrophySystem.this.tileEntity.toggleFilter((EntityEntry)GuiTrophySystem.this.orderedFilterList.get(index));
                GuiTrophySystem.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }

        protected void drawSlot(int slotIndex, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            if (GuiTrophySystem.this.isSmart && this.mouseX >= this.left && this.mouseX <= entryRight && slotIndex >= 0 && slotIndex < this.getSize() && this.mouseY >= slotTop - 1 && this.mouseY <= slotTop + slotBuffer + 2) {
                this.hoveredSlot = slotIndex;
            } else if (this.mouseX < this.left || this.mouseX > this.right || this.mouseY < this.top || this.mouseY > this.bottom) {
                this.hoveredSlot = -1;
            }
            EntityEntry projectileType = (EntityEntry)GuiTrophySystem.this.orderedFilterList.get(slotIndex);
            String projectileName = projectileType == TileEntityTrophySystem.MODDED_PROJECTILES ? GuiTrophySystem.this.moddedProjectiles : projectileType.newInstance((World)GuiTrophySystem.this.field_146297_k.field_71441_e).func_70005_c_();
            projectileName = projectileName.replace("entity.", "").replace(".name", "");
            GuiTrophySystem.this.field_146289_q.func_78276_b(projectileName, this.left + this.listWidth / 2 - GuiTrophySystem.this.field_146289_q.func_78256_a(projectileName) / 2, slotTop, 0xC6C6C6);
            GuiTrophySystem.this.field_146297_k.func_110434_K().func_110577_a(BEACON_GUI);
            Gui.func_152125_a((int)this.left, (int)(slotTop - 3), (float)(GuiTrophySystem.this.tileEntity.getFilter(projectileType) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)14, (int)14, (float)256.0f, (float)256.0f);
        }
    }
}

