/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMineRemoteAccessTool
extends Item {
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            player.openGui((Object)SecurityCraft.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() instanceof IExplosive) {
            if (!this.isMineAdded(stack, pos)) {
                int availSlot = this.getNextAvailableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessMine.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(player)) {
                    player.openGui((Object)SecurityCraft.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    return EnumActionResult.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74783_a("mine" + availSlot, BlockUtils.posToIntArray(pos));
                if (!world.field_72995_K) {
                    SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
                }
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessMine.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:mrat.bound", pos), TextFormatting.GREEN);
                return EnumActionResult.SUCCESS;
            }
            this.removeTagFromItemAndUpdate(stack, pos, player);
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:remoteAccessMine.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:mrat.unbound", pos), TextFormatting.RED);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            if (stack.func_77978_p().func_74759_k("mine" + i).length > 0) {
                int[] coords = stack.func_77978_p().func_74759_k("mine" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add("---");
                    continue;
                }
                list.add(Utils.localize("tooltip.securitycraft:mine", new Object[0]).func_150254_d() + " " + i + ": X:" + coords[0] + " Y:" + coords[1] + " Z:" + coords[2]);
                continue;
            }
            list.add("---");
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            if (!player.field_70170_p.field_72995_K) {
                SecurityCraft.network.sendTo((IMessage)new UpdateNBTTagOnClient(stack), (EntityPlayerMP)player);
            }
            return;
        }
    }

    private boolean isMineAdded(ItemStack stack, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvailableSlot(ItemStack stack) {
        for (int i = 1; i <= 6; ++i) {
            if (stack.func_77978_p() == null) {
                return 1;
            }
            if (stack.func_77978_p().func_74759_k("mine" + i).length != 0 && (stack.func_77978_p().func_74759_k("mine" + i)[0] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[1] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

