/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import net.geforcemods.securitycraft.misc.PageType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;

public class SCManualPage {
    private final Item item;
    private final PageType pageType;
    private final TextComponentTranslation title;
    private final TextComponentTranslation helpInfo;
    private final String designedBy;
    private final boolean hasRecipeDescription;
    private final NonNullList<Ingredient> customRecipe;
    private final boolean configValue;

    public SCManualPage(Item item, PageType pageType, TextComponentTranslation title, TextComponentTranslation helpInfo, String designedBy, boolean hasRecipeDescription) {
        this.item = item;
        this.pageType = pageType;
        this.title = title;
        this.helpInfo = helpInfo;
        this.designedBy = designedBy;
        this.hasRecipeDescription = hasRecipeDescription;
        this.configValue = true;
        this.customRecipe = null;
    }

    public SCManualPage(Item item, PageType pageType, TextComponentTranslation title, TextComponentTranslation helpInfo, String designedBy, boolean hasRecipeDescription, boolean configValue) {
        this.item = item;
        this.pageType = pageType;
        this.title = title;
        this.helpInfo = helpInfo;
        this.designedBy = designedBy;
        this.hasRecipeDescription = hasRecipeDescription;
        this.configValue = configValue;
        this.customRecipe = null;
    }

    public SCManualPage(Item item, TextComponentTranslation title, TextComponentTranslation helpInfo, NonNullList<Ingredient> customRecipe) {
        this.item = item;
        this.pageType = PageType.SINGLE_ITEM;
        this.title = title;
        this.helpInfo = helpInfo;
        this.designedBy = "";
        this.hasRecipeDescription = false;
        this.configValue = true;
        this.customRecipe = customRecipe;
    }

    public Item getItem() {
        return this.item;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public TextComponentTranslation getTitle() {
        return this.title;
    }

    public TextComponentTranslation getHelpInfo() {
        return this.helpInfo;
    }

    public String getDesignedBy() {
        return this.designedBy;
    }

    public boolean hasRecipeDescription() {
        return this.hasRecipeDescription;
    }

    public NonNullList<Ingredient> getRecipe() {
        return this.customRecipe;
    }

    public boolean hasCustomRecipe() {
        return this.customRecipe != null;
    }

    public boolean isRecipeDisabled() {
        return !this.configValue;
    }
}

