/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncTENBTTag
implements IMessage {
    private int x;
    private int y;
    private int z;
    private NBTTagCompound tag;

    public SyncTENBTTag() {
    }

    public SyncTENBTTag(int x, int y, int z, NBTTagCompound tag) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.tag = tag;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public static class Handler
    implements IMessageHandler<SyncTENBTTag, IMessage> {
        public IMessage onMessage(SyncTENBTTag message, MessageContext ctx) {
            WorldUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntity te = player.field_70170_p.func_175625_s(pos);
                if (te instanceof IOwnable && ((IOwnable)te).getOwner().isOwner((EntityPlayer)player)) {
                    te.func_145839_a(message.tag);
                }
            });
            return null;
        }
    }
}

