/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.util.TileEntityRenderDelegate;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityLaserBlock
extends TileEntityLinkable {
    private Option.OptionBoolean enabledOption = new Option.OptionBoolean("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            TileEntityLaserBlock.this.toggleLaser(this);
        }
    };

    private void toggleLaser(Option.OptionBoolean option) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block != SCContent.laserBlock) {
            return;
        }
        if (((Boolean)option.get()).booleanValue()) {
            ((BlockLaserBlock)block).setLaser(((TileEntityLaserBlock)this.field_145850_b.func_175625_s(this.field_174879_c)).getOwner(), this.field_145850_b, this.field_174879_c);
        } else {
            BlockLaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<TileEntityLinkable> excludedTEs) {
        if (action == EnumLinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.OptionBoolean)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            if (((ItemModule)module.func_77973_b()).getModuleType() == EnumModuleType.DISGUISE) {
                this.onInsertDisguiseModule(module);
            }
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            EnumModuleType module = (EnumModuleType)((Object)parameters[1]);
            ItemStack moduleStack = this.getModule(module);
            this.removeModule(module);
            if (module == EnumModuleType.DISGUISE) {
                this.onRemoveDisguiseModule(moduleStack);
            }
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        if (module == EnumModuleType.DISGUISE) {
            this.onInsertDisguiseModule(stack);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == EnumModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(stack);
        }
    }

    private void onInsertDisguiseModule(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAll((IMessage)new RefreshDiguisedModel(this.field_174879_c, true, stack));
        } else {
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
        }
    }

    private void onRemoveDisguiseModule(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAll((IMessage)new RefreshDiguisedModel(this.field_174879_c, false, stack));
        } else {
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            TileEntityRenderDelegate.putDisguisedTeRenderer(this, this.getModule(EnumModuleType.DISGUISE));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            TileEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.HARMING, EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

