/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ITickable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileEntityRetinalScanner
extends TileEntityDisguisable
implements IViewActivated,
ITickable,
ILockable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private Option.OptionBoolean activatedByEntities = new Option.OptionBoolean("activatedByEntities", false);
    private Option.OptionBoolean sendMessage = new Option.OptionBoolean("sendMessage", true);
    private Option.OptionInt signalLength = new Option.OptionInt(() -> ((TileEntityRetinalScanner)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private GameProfile ownerProfile;
    private int viewCooldown = 0;

    public void func_73660_a() {
        this.checkView(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean onEntityViewed(EntityLivingBase entity, RayTraceResult rayTraceResult) {
        if (!this.isLocked()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177229_b((IProperty)BlockRetinalScanner.FACING) != rayTraceResult.field_178784_b) {
                return false;
            }
            if (!((Boolean)state.func_177229_b((IProperty)BlockRetinalScanner.POWERED)).booleanValue() && !EntityUtils.isInvisible(entity)) {
                String name = entity.func_70005_c_();
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (ConfigHandler.trickScannersWithPlayerHeads && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Items.field_151144_bL) {
                        name = PlayerUtils.getNameOfSkull(player);
                    }
                    if (name == null || !this.getOwner().getName().equals(name) && !ModuleUtils.isAllowed((IModuleInventory)this, name)) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.retinalScanner, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), TextFormatting.RED);
                        return true;
                    }
                } else if (this.activatedOnlyByPlayer()) {
                    return false;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockRetinalScanner.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.retinalScanner);
                this.field_145850_b.func_175684_a(this.field_174879_c, SCContent.retinalScanner, this.getSignalLength());
                if (entity instanceof EntityPlayer && ((Boolean)this.sendMessage.get()).booleanValue()) {
                    PlayerUtils.sendMessageToPlayer((EntityPlayer)entity, (ITextComponent)Utils.localize("tile.securitycraft:retinalScanner.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", name), TextFormatting.GREEN);
                }
                return true;
            }
        } else if (entity instanceof EntityPlayer && ((Boolean)this.sendMessage.get()).booleanValue()) {
            PlayerUtils.sendMessageToPlayer((EntityPlayer)entity, (ITextComponent)Utils.localize(SCContent.retinalScanner, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", Utils.localize(SCContent.retinalScanner, new Object[0])), TextFormatting.DARK_RED, false);
            return true;
        }
        return false;
    }

    @Override
    public int getDefaultViewCooldown() {
        return this.getSignalLength() + 30;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
    }

    @Override
    public boolean activatedOnlyByPlayer() {
        return (Boolean)this.activatedByEntities.get() == false;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.ALLOWLIST, EnumModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.activatedByEntities, this.sendMessage, this.signalLength};
    }

    public static void setProfileCache(PlayerProfileCache profileCacheIn) {
        profileCache = profileCacheIn;
    }

    public static void setSessionService(MinecraftSessionService sessionServiceIn) {
        sessionService = sessionServiceIn;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (!StringUtils.func_151246_b((String)this.getOwner().getName()) && !this.getOwner().getName().equals("owner")) {
            if (this.ownerProfile == null || !this.getOwner().getName().equals(this.ownerProfile.getName())) {
                this.setPlayerProfile(new GameProfile((UUID)null, this.getOwner().getName()));
            }
            this.updatePlayerProfile();
            NBTTagCompound ownerProfileTag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)ownerProfileTag, (GameProfile)this.ownerProfile);
            tag.func_74782_a("ownerProfile", (NBTBase)ownerProfileTag);
            return tag;
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ownerProfile = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("ownerProfile"));
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.ownerProfile;
    }

    public void setPlayerProfile(@Nullable GameProfile profile) {
        this.ownerProfile = profile;
    }

    public void updatePlayerProfile() {
        if (profileCache == null && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            TileEntityRetinalScanner.setProfileCache(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax());
        }
        if (sessionService == null && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            TileEntityRetinalScanner.setSessionService(FMLCommonHandler.instance().getMinecraftServerInstance().func_147130_as());
        }
        this.ownerProfile = this.updateGameProfile(this.ownerProfile);
    }

    private GameProfile updateGameProfile(GameProfile input) {
        if (ConfigHandler.retinalScannerFace && input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    try {
                        gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("========= WARNING =========");
                        LOGGER.warn("The following error is likely caused by using an offline server. If you are not using an offline server (online-mode=true in the server.properties), please reach out to the SecurityCraft devs in their Discord #help channel: https://discord.gg/U8DvBAW");
                        LOGGER.warn("To mitigate this error, you can set the configuration option \"retinalScannerFace\" to false, in order to disable rendering the owner's face on retinal scanners.");
                        LOGGER.error("The exception's stacktrace is as follows:", (Throwable)e);
                    }
                }
                return gameprofile;
            }
            return input;
        }
        return input;
    }
}

