/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.blocks.BlockScannerDoor;
import net.geforcemods.securitycraft.tileentity.TileEntitySpecialDoor;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileEntityScannerDoor
extends TileEntitySpecialDoor
implements IViewActivated,
ILockable {
    private int viewCooldown = 0;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.checkView(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean onEntityViewed(EntityLivingBase entity, RayTraceResult rayTraceResult) {
        IBlockState upperState = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState lowerState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (upperState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER && !EntityUtils.isInvisible(entity)) {
            EnumFacing.Axis facingAxis = BlockScannerDoor.getFacingAxis(lowerState);
            if (!(entity instanceof EntityPlayer) || facingAxis != rayTraceResult.field_178784_b.func_176740_k()) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.isLocked()) {
                String name = entity.func_70005_c_();
                if (ConfigHandler.trickScannersWithPlayerHeads && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Items.field_151144_bL) {
                    name = PlayerUtils.getNameOfSkull(player);
                }
                if (name == null || !this.getOwner().getName().equals(name) && !ModuleUtils.isAllowed((IModuleInventory)this, name)) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.retinalScanner, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), TextFormatting.RED);
                    return true;
                }
                boolean open = (Boolean)lowerState.func_177229_b((IProperty)BlockDoor.field_176519_b) == false;
                int length = this.getSignalLength();
                this.field_145850_b.func_180501_a(this.field_174879_c, upperState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(open)), 3);
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), lowerState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(open)), 3);
                this.field_145850_b.func_175704_b(this.field_174879_c.func_177977_b(), this.field_174879_c);
                this.field_145850_b.func_180498_a(null, open ? 1005 : 1011, this.field_174879_c, 0);
                if (open && length > 0) {
                    this.field_145850_b.func_175684_a(this.field_174879_c, SCContent.scannerDoor, length);
                }
                if (open && this.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:scannerDoorItem.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", name), TextFormatting.GREEN);
                }
                return true;
            }
            if (this.sendsMessages()) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)entity, (ITextComponent)Utils.localize(SCContent.scannerDoor, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", Utils.localize(SCContent.scannerDoor, new Object[0])), TextFormatting.DARK_RED, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
    }

    @Override
    public int defaultSignalLength() {
        return 0;
    }
}

