/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ModuleUtils {
    public static List<String> getPlayersFromModule(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77973_b() instanceof ItemModule) {
            for (int i = 1; i <= 50; ++i) {
                if (stack.func_77978_p() == null || stack.func_77978_p().func_74779_i("Player" + i) == null || stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add(stack.func_77978_p().func_74779_i("Player" + i).toLowerCase());
            }
        }
        return list;
    }

    public static boolean isAllowed(IModuleInventory inv, Entity entity) {
        return ModuleUtils.isAllowed(inv, entity.func_70005_c_());
    }

    public static boolean isAllowed(IModuleInventory inv, String name) {
        ItemStack stack = inv.getModule(EnumModuleType.ALLOWLIST);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("affectEveryone")) {
            return true;
        }
        return ModuleUtils.getPlayersFromModule(stack).contains(name.toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDenied(IModuleInventory inv, Entity entity) {
        ItemStack stack = inv.getModule(EnumModuleType.DENYLIST);
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("affectEveryone")) return ModuleUtils.getPlayersFromModule(stack).contains(entity.func_70005_c_().toLowerCase());
        if (!(inv.getTileEntity() instanceof IOwnable)) return true;
        if (!(entity instanceof EntityPlayer)) return true;
        if (((IOwnable)inv.getTileEntity()).getOwner().isOwner((EntityPlayer)entity)) return ModuleUtils.getPlayersFromModule(stack).contains(entity.func_70005_c_().toLowerCase());
        return true;
    }

    public static void createLinkedAction(EnumLinkedAction action, ItemStack stack, TileEntityLinkable te) {
        if (action == EnumLinkedAction.MODULE_INSERTED) {
            te.createLinkedBlockAction(action, new Object[]{stack, (ItemModule)stack.func_77973_b()}, te);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            te.createLinkedBlockAction(action, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModuleType()}, te);
        }
    }
}

