/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityBoat
extends EntityPoweredVehicle {
    protected State state;
    protected State previousState;
    private float waterLevel;

    public EntityBoat(World worldIn) {
        super(worldIn);
        this.setMaxTurnAngle(65);
    }

    @Override
    public boolean canChangeWheels() {
        return false;
    }

    @Override
    public void updateVehicleMotion() {
        if (this.state == State.ON_WATER || this.state == State.UNDER_WATER) {
            if (this.state == State.UNDER_WATER) {
                this.field_70181_x += 0.12;
            } else {
                double floatingY = ((double)this.waterLevel - 0.35 + 0.25 * (double)Math.min(1.0f, this.getNormalSpeed()) - this.field_70163_u) / (double)this.field_70131_O;
                this.field_70181_x += floatingY * 0.05;
                if (Math.abs(floatingY) < 0.1 && this.field_70181_x > 0.0 && Math.abs(this.field_70181_x) < 0.1) {
                    this.func_70107_b(this.field_70165_t, (double)this.waterLevel - 0.35 + 0.25 * (double)Math.min(1.0f, this.getNormalSpeed()), this.field_70161_v);
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x *= 0.75;
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            this.vehicleMotionX = -this.currentSpeed * f1;
            this.vehicleMotionZ = this.currentSpeed * f2;
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
        } else if (this.state == State.IN_AIR) {
            this.field_70181_x -= 0.08;
            if (this.previousState == State.UNDER_WATER || this.previousState == State.ON_WATER) {
                this.field_70159_w = this.vehicleMotionX;
                this.field_70179_y = this.vehicleMotionZ;
                this.vehicleMotionX = 0.0f;
                this.vehicleMotionZ = 0.0f;
            }
        } else {
            this.vehicleMotionX *= 0.75f;
            this.vehicleMotionZ *= 0.75f;
        }
    }

    @Override
    public void updateVehicle() {
        this.previousState = this.state;
        this.state = this.getState();
        if (this.state == State.IN_AIR) {
            this.deltaYaw *= 2.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnWater() {
        this.waterLevel = Float.MIN_VALUE;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        AxisAlignedBB axisAligned = this.func_174813_aQ();
        int minX = MathHelper.func_76128_c((double)axisAligned.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)axisAligned.field_72336_d);
        int minY = MathHelper.func_76128_c((double)axisAligned.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)(axisAligned.field_72338_b + 0.01));
        int minZ = MathHelper.func_76128_c((double)axisAligned.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)axisAligned.field_72334_f);
        boolean inWater = false;
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        if (state.func_185904_a() != Material.field_151586_h) continue;
                        float liquidHeight = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos);
                        this.waterLevel = Math.max(liquidHeight, this.waterLevel);
                        boolean bl = axisAligned.field_72338_b < (double)liquidHeight;
                        return bl;
                    }
                }
            }
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
        return inWater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnderWater() {
        AxisAlignedBB axisAligned = this.func_174813_aQ();
        double height = axisAligned.field_72338_b + 0.001;
        int minX = MathHelper.func_76128_c((double)axisAligned.field_72340_a);
        int maxX = MathHelper.func_76143_f((double)axisAligned.field_72336_d);
        int minY = MathHelper.func_76128_c((double)axisAligned.field_72338_b);
        int maxY = MathHelper.func_76143_f((double)height);
        int minZ = MathHelper.func_76128_c((double)axisAligned.field_72339_c);
        int maxZ = MathHelper.func_76143_f((double)axisAligned.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos mutableBlockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        mutableBlockPos.func_181079_c(x, y + 1, z);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)mutableBlockPos);
                        if (state.func_185904_a() != Material.field_151586_h || !(height < (double)BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)this.field_70170_p, (BlockPos)mutableBlockPos))) continue;
                        if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            boolean bl = true;
                            return bl;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            mutableBlockPos.func_185344_t();
        }
        return flag;
    }

    protected State getState() {
        if (this.isUnderWater()) {
            return State.UNDER_WATER;
        }
        if (this.isOnWater()) {
            return State.ON_WATER;
        }
        if (this.field_70122_E) {
            return State.ON_LAND;
        }
        return State.IN_AIR;
    }

    @Override
    protected void updateGroundState() {
        this.wheelsOnGround = this.getState() == State.ON_WATER || this.getState() == State.UNDER_WATER;
    }

    protected static enum State {
        ON_WATER,
        UNDER_WATER,
        IN_AIR,
        ON_LAND;

    }
}

