/*
 * Decompiled with CFR 0.152.
 */
package treechopper.common.command;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import treechopper.common.config.ConfigurationHandler;
import treechopper.common.network.ClientSettingsMessage;
import treechopper.core.TreeChopper;
import treechopper.proxy.CommonProxy;

public class TCHCommand
extends CommandBase {
    public String func_71517_b() {
        return "treechopper";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"tch"});
    }

    public String func_71518_a(ICommandSender sender) {
        return this.GetTranslatedText(sender, "command.errorMessage", "Type \"/tch help\" for help");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0 && args[0].equals("printName")) {
            if (args.length != 2) {
                throw new WrongUsageException("/tch printName 0/1", new Object[0]);
            }
            try {
                CommonProxy.m_PlayerPrintNames.put(sender.func_174793_f().getPersistentID(), TCHCommand.func_180527_d((String)args[1]));
                return;
            }
            catch (Exception e) {
                System.out.printf("Not a player", new Object[0]);
            }
            return;
        }
        if (sender.func_70003_b(this.func_82362_a(), this.func_71517_b())) {
            if (args.length < 1) {
                throw new WrongUsageException(this.GetTranslatedText(sender, "command.errorMessage", "Type \"/tch help\" for help"), new Object[0]);
            }
            if (args[0].equals("help")) {
                this.GetUsage(sender);
                return;
            } else if (args[0].equals("info")) {
                this.GetInfo(sender);
                return;
            } else if (args[0].equals("decLeaves")) {
                if (args.length != 2) {
                    throw new WrongUsageException("/tch decLeaves 0/1", new Object[0]);
                }
                ConfigurationHandler.setDecayLea(TCHCommand.func_180527_d((String)args[1]));
                if (ConfigurationHandler.decayLeaves) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.decayLeavesSwitch", "Decay leaves has been switched") + " " + TextFormatting.GREEN + "ON", new Object[0]));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.decayLeavesSwitch", "Decay leaves has been switched") + " " + TextFormatting.RED + "OFF", new Object[0]));
                }
                return;
            } else if (args[0].equals("plantSap")) {
                if (args.length != 2) {
                    throw new WrongUsageException("/tch plantSap 0/1", new Object[0]);
                }
                ConfigurationHandler.setPlantSap(TCHCommand.func_180527_d((String)args[1]));
                if (ConfigurationHandler.plantSapling) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.plantSaplingSwitch", "Auto planting has been switched") + " " + TextFormatting.GREEN + "ON", new Object[0]));
                    return;
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.plantSaplingSwitch", "Auto planting has been switched") + " " + TextFormatting.RED + "OFF", new Object[0]));
                }
                return;
            } else if (args[0].equals("revShift")) {
                if (args.length != 2) {
                    throw new WrongUsageException("/tch revShift 0/1", new Object[0]);
                }
                ConfigurationHandler.setReverseShi(TCHCommand.func_180527_d((String)args[1]));
                if (ConfigurationHandler.reverseShift) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.reverseShiftSwitch", "Reverse function has been switched") + " " + TextFormatting.GREEN + "ON", new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.reverseShiftSwitch", "Reverse function has been switched") + " " + TextFormatting.RED + "OFF", new Object[0]));
                }
                TreeChopper.m_Network.sendToAll((IMessage)new ClientSettingsMessage(ConfigurationHandler.reverseShift, ConfigurationHandler.disableShift));
                return;
            } else {
                if (!args[0].equals("disShift")) throw new WrongUsageException(this.GetTranslatedText(sender, "command.errorMessage", "Type \"/tch help\" for help"), new Object[0]);
                if (args.length != 2) {
                    throw new WrongUsageException("/tch disShift 0/1", new Object[0]);
                }
                ConfigurationHandler.setDisableShi(TCHCommand.func_180527_d((String)args[1]));
                if (ConfigurationHandler.disableShift) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.disableShiftSwitch", "Disable shift function has been switched") + " " + TextFormatting.GREEN + "ON", new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("[" + TextFormatting.GOLD + "TCH" + TextFormatting.RESET + "] " + this.GetTranslatedText(sender, "command.disableShiftSwitch", "Disable shift function has been switched") + " " + TextFormatting.RED + "OFF", new Object[0]));
                }
                TreeChopper.m_Network.sendToAll((IMessage)new ClientSettingsMessage(ConfigurationHandler.disableShift, ConfigurationHandler.disableShift));
            }
            return;
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + this.GetTranslatedText(sender, "command.permissions", "You do not have permission to use this command"), new Object[0]));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return TCHCommand.func_71530_a((String[])args, (String[])new String[]{"info", "plantSap", "decLeaves", "revShift", "help", "printName", "disShift"});
        }
        return null;
    }

    private void GetUsage(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "Tree Chopper", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "/tch info" + TextFormatting.RESET + " -" + TextFormatting.ITALIC + this.GetTranslatedText(sender, "command.infoInfo", " Print info about server settings"), new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "/tch plantSap" + TextFormatting.RESET + " 0/1 -" + TextFormatting.ITALIC + this.GetTranslatedText(sender, "command.plantSaplingInfo", " Auto plant sapling, around his trunk"), new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "/tch decLeaves" + TextFormatting.RESET + " 0/1 -" + TextFormatting.ITALIC + this.GetTranslatedText(sender, "command.decayLeavesInfo", " Decay leaves with tree fall"), new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "/tch revShift" + TextFormatting.RESET + " 0/1 -" + TextFormatting.ITALIC + this.GetTranslatedText(sender, "command.reverseShiftInfo", " Reverse shift function"), new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + "/tch disShift" + TextFormatting.RESET + " 0/1 -" + TextFormatting.ITALIC + this.GetTranslatedText(sender, "command.disableShiftInfo", " Disable shift function"), new Object[0]));
    }

    private void GetInfo(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GOLD + "Tree Chopper", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.GetTranslatedText(sender, "command.decayLeaves", "Leaves decay:") + " " + TextFormatting.ITALIC + ConfigurationHandler.decayLeaves, new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.GetTranslatedText(sender, "command.plantSapling", "Automatic sapling plant:") + " " + TextFormatting.ITALIC + ConfigurationHandler.plantSapling, new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.GetTranslatedText(sender, "command.reverseShift", "Reverse func:") + " " + TextFormatting.ITALIC + ConfigurationHandler.reverseShift, new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(this.GetTranslatedText(sender, "command.disableShift", "Disable shift:") + " " + TextFormatting.ITALIC + ConfigurationHandler.disableShift, new Object[0]));
    }

    private String GetTranslatedText(ICommandSender sender, String translateKey, String text) {
        if (sender.func_184102_h() != null && sender.func_184102_h().func_71264_H()) {
            return I18n.func_135052_a((String)translateKey, (Object[])new Object[0]);
        }
        return text;
    }
}

