/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork;

import mrriegel.storagenetwork.apiimpl.AnnotatedInstanceUtil;
import mrriegel.storagenetwork.apiimpl.PluginRegistry;
import mrriegel.storagenetwork.apiimpl.StorageNetworkHelpers;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.datafixes.FixManager;
import mrriegel.storagenetwork.proxy.CommonProxy;
import mrriegel.storagenetwork.registry.RegistryEvents;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="storagenetwork", name="Simple Storage Network", certificateFingerprint="0e5cb559be7d03f3fc18b8cba547d663e25f28af", version="1.8.3", updateJSON="https://raw.githubusercontent.com/Lothrazar/Storage-Network/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class StorageNetwork {
    public Logger logger;
    public static final String MODID = "storagenetwork";
    public static final String MODNAME = "Simple Storage Network";
    public static final String VERSION = "1.8.3";
    @Mod.Instance(value="storagenetwork")
    public static StorageNetwork instance;
    @SidedProxy(clientSide="mrriegel.storagenetwork.proxy.ClientProxy", serverSide="mrriegel.storagenetwork.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final PluginRegistry pluginRegistry;
    public static StorageNetworkHelpers helpers;
    private static FixManager fixManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        fixManager = new FixManager();
        AnnotatedInstanceUtil.asmDataTable = event.getAsmData();
        pluginRegistry.loadStorageNetworkPlugins();
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new RegistryEvents());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        pluginRegistry.forEach(iStorageNetworkPlugin -> iStorageNetworkPlugin.helpersReady(helpers));
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "Storage Network: Invalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        if (this.logger == null) {
            System.out.println(msg);
        } else {
            this.logger.error(msg);
        }
    }

    public static void chatMessage(EntityPlayer player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(StorageNetwork.lang(message)));
        }
    }

    public static void statusMessage(EntityPlayer player, String message) {
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentString(StorageNetwork.lang(message)), true);
        }
    }

    public static String lang(String message) {
        return I18n.func_74838_a((String)message);
    }

    public static void log(String s) {
        if (ConfigHandler.logEverything) {
            StorageNetwork.instance.logger.info(s);
        }
    }

    public static void error(String s) {
        StorageNetwork.instance.logger.error(s);
    }

    static {
        pluginRegistry = new PluginRegistry();
        helpers = new StorageNetworkHelpers();
    }
}

