/*
 * Decompiled with CFR 0.152.
 */
package soletare.mopickaxes.items.pickaxes;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soletare.mopickaxes.MoPickaxes;
import soletare.mopickaxes.init.MPTab;
import soletare.mopickaxes.items.MPModelProvider;

public class MPGoldenApplePickaxe
extends ItemPickaxe
implements MPModelProvider {
    private String name;
    public final int itemUseDuration;
    private final int healAmount;
    private final float saturationModifier;
    private final boolean isWolfsFavoriteMeat;
    private boolean alwaysEdible;
    private PotionEffect potionId;
    private float potionEffectProbability;

    public MPGoldenApplePickaxe(Item.ToolMaterial material, String name, int amount, float saturation, boolean isWolfFood) {
        super(material);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.name = name;
        this.func_77637_a(MPTab.mpTab);
        this.itemUseDuration = 32;
        this.healAmount = amount;
        this.isWolfsFavoriteMeat = isWolfFood;
        this.saturationModifier = saturation;
    }

    @Override
    public void registerItemModel(Item item) {
        MoPickaxes.proxy.registerItemRenderer((Item)this, 0, this.name);
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(this.healAmount, this.saturationModifier);
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(stack, worldIn, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            super.func_77654_b(stack, worldIn, (EntityLivingBase)entityplayer);
            return new ItemStack(Items.field_151055_y, 2);
        }
        return stack;
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 300, 3));
            player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 7200, 0));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World itemStackIn, EntityPlayer worldIn, EnumHand playerIn) {
        ItemStack itemstack = worldIn.func_184586_b(playerIn);
        if (worldIn.func_71043_e(this.alwaysEdible)) {
            worldIn.func_184598_c(playerIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public int getHealAmount(ItemStack stack) {
        return this.healAmount;
    }

    public float getSaturationModifier(ItemStack stack) {
        return this.saturationModifier;
    }

    public boolean isWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }

    public MPGoldenApplePickaxe setPotionEffect(PotionEffect p_185070_1_, float p_185070_2_) {
        this.potionId = p_185070_1_;
        this.potionEffectProbability = p_185070_2_;
        return this;
    }

    public MPGoldenApplePickaxe setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add("Gives effects of three golden apples at ones!");
        tooltip.add("Rare");
    }

    public void registerItemModel() {
        MoPickaxes.proxy.registerItemRenderer((Item)this, 0, this.name);
    }
}

