/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.blocks;

import com.advancedcombat.api.IBlockAdvanced;
import com.advancedcombat.creativetabs.ACCreativeTabs;
import com.advancedcombat.util.ACUtils;
import com.advancedcombat.util.TrackingDispenserBehavior;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockTrackingDispenser
extends BlockDispenser
implements IBlockAdvanced {
    public BlockTrackingDispenser() {
        this.func_149711_c(Blocks.field_150367_z.func_176195_g(null, null, null));
        this.func_149647_a(ACCreativeTabs.main);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        BlockSourceImpl src = new BlockSourceImpl(worldIn, pos);
        TileEntityDispenser tile = (TileEntityDispenser)src.func_150835_j();
        if (!tile.func_145818_k_()) {
            tile.func_190575_a(this.func_149732_F());
        }
    }

    protected void func_176439_d(World worldIn, BlockPos pos) {
        BlockSourceImpl src = new BlockSourceImpl(worldIn, pos);
        TileEntityDispenser tile = (TileEntityDispenser)src.func_150835_j();
        if (tile != null) {
            int i = tile.func_146017_i();
            if (i < 0) {
                worldIn.func_175718_b(1001, pos, 0);
            } else {
                ItemStack itemstack = tile.func_70301_a(i);
                IBehaviorDispenseItem defaultbehavior = this.func_149940_a(itemstack);
                if (defaultbehavior != IBehaviorDispenseItem.field_82483_a) {
                    ItemStack itemstack1 = null;
                    if (defaultbehavior instanceof BehaviorProjectileDispense) {
                        itemstack1 = this.dispenseProjectile((BehaviorProjectileDispense)defaultbehavior, (IBlockSource)src, itemstack);
                    } else if (itemstack.func_77973_b() instanceof ItemSplashPotion || itemstack.func_77973_b() instanceof ItemLingeringPotion) {
                        itemstack1 = this.dispensePotion((IBlockSource)src, itemstack);
                    } else if (itemstack.func_77973_b() instanceof ItemFireball) {
                        itemstack1 = this.dispenseFireball((IBlockSource)src, itemstack);
                    }
                    if (itemstack1 == null) {
                        itemstack1 = defaultbehavior.func_82482_a((IBlockSource)src, itemstack);
                    }
                    tile.func_70299_a(i, itemstack1.func_190916_E() <= 0 ? ItemStack.field_190927_a : itemstack1);
                }
            }
        }
    }

    public ItemStack dispenseProjectile(BehaviorProjectileDispense base, IBlockSource source, ItemStack stack) {
        ItemStack itemstack = new TrackingDispenserBehavior.BehaviorTrackingProjectileDispense(base).dispenseStack(source, stack);
        if (itemstack != null) {
            this.playDispenseSound(source);
            this.spawnDispenseParticles(source, ACUtils.getDispenserFacing(ACUtils.getBlockSourceMetadata(source)));
        }
        return itemstack;
    }

    public ItemStack dispensePotion(IBlockSource source, ItemStack stack) {
        BehaviorProjectileDispense base = new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stack) {
                return new EntityPotion(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stack.func_77946_l());
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        };
        return this.dispenseProjectile(base, source, stack);
    }

    public ItemStack dispenseFireball(IBlockSource source, ItemStack stack) {
        ItemStack itemstack = new TrackingDispenserBehavior.BehaviorTrackingFireballDispense().dispenseStack(source, stack);
        if (itemstack != null) {
            this.playFireballSound(source);
            this.spawnDispenseParticles(source, ACUtils.getDispenserFacing(ACUtils.getBlockSourceMetadata(source)));
        }
        return itemstack;
    }

    private void playDispenseSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
    }

    private void playFireballSound(IBlockSource source) {
        source.func_82618_k().func_175718_b(1018, source.func_180699_d(), 0);
    }

    private void spawnDispenseParticles(IBlockSource source, EnumFacing facingIn) {
        source.func_82618_k().func_175718_b(2000, source.func_180699_d(), this.func_82488_a(facingIn));
    }

    private int func_82488_a(EnumFacing facingIn) {
        return facingIn.func_82601_c() + 1 + (facingIn.func_82599_e() + 1) * 3;
    }
}

