/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.crafting;

import com.advancedcombat.util.ACUtils;
import com.advancedcombat.util.JointList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RecipeEnchantmentUpgrade
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static List<RecipeEnchantmentUpgrade> allUpgrades = new JointList<RecipeEnchantmentUpgrade>();
    protected ItemStack upgrade;
    protected Enchantment enchant;
    protected int minLevel;
    protected int maxLevel;

    protected RecipeEnchantmentUpgrade(@Nonnull ItemStack upgrade, Enchantment toUpgrade, int minLevel, int maxLevel) {
        this.upgrade = upgrade;
        this.enchant = toUpgrade;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        allUpgrades.add(this);
    }

    public static List<RecipeEnchantmentUpgrade> getAllUpgrades() {
        return allUpgrades;
    }

    public ItemStack getUpgrade() {
        return this.upgrade;
    }

    public Enchantment getEnchantment() {
        return this.enchant;
    }

    public int getMinLevelToApply() {
        return this.minLevel;
    }

    public int getMaxUpgradeLevel() {
        return this.maxLevel;
    }

    @Nonnull
    public ItemStack getUpgradableStack(@Nonnull List<ItemStack> s) {
        ItemStack toUpgrade;
        if (ACUtils.doesItemStackListContain(s, this.upgrade, true) && this.enchant.func_92089_a(toUpgrade = s.get(0)) && toUpgrade.func_77973_b() instanceof ItemSword) {
            Map activeEnchs = EnchantmentHelper.func_82781_a((ItemStack)toUpgrade);
            for (Enchantment i : activeEnchs.keySet()) {
                int level;
                if (i != this.enchant || (level = ((Integer)activeEnchs.get(i)).intValue()) < this.maxLevel) continue;
                return ItemStack.field_190927_a;
            }
            return toUpgrade.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        JointList<ItemStack> s = new JointList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            s.add(inv.func_70301_a(i));
        }
        return s.size() == 2 && !this.getUpgradableStack(s).func_190926_b();
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        JointList<ItemStack> s = new JointList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            s.add(inv.func_70301_a(i));
        }
        ItemStack c = this.getUpgradableStack(s);
        if (c.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Map map = EnchantmentHelper.func_82781_a((ItemStack)c);
        int clevel = EnchantmentHelper.func_77506_a((Enchantment)this.enchant, (ItemStack)c);
        for (Enchantment i : map.keySet()) {
            if (i != this.enchant || (Integer)map.get(i) < this.minLevel) continue;
            int newLevel = (Integer)map.get(i) + 1;
            map.put(i, newLevel);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)c);
            return c;
        }
        if (this.minLevel <= 0) {
            map.put(this.enchant, 1);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)c);
            return c;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }
}

