/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.events;

import com.advancedcombat.items.ItemArmorNether;
import com.advancedcombat.items.ItemArmorObsidian;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArmorHandler {
    static final UUID knockbackID = UUID.fromString("1af01788-c878-4a98-868a-d4a6365be699");

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K && e.getSource() != null) {
            this.netherFortressArmor(e);
            this.obsidianArmor(e);
        }
    }

    private boolean netherFortressArmor(LivingHurtEvent e) {
        EntityLivingBase hurt = e.getEntityLiving();
        int armorCount = ArmorHandler.getWearingSetCount(hurt, ItemArmorNether.class);
        if (armorCount > 0) {
            IAttributeInstance inst = hurt.func_110148_a(SharedMonsterAttributes.field_111266_c);
            AttributeModifier mod = new AttributeModifier(knockbackID, "nfakb", (double)armorCount / 4.0, 0).func_111168_a(false);
            if (inst.func_111127_a(knockbackID) == null) {
                inst.func_111121_a(mod);
            }
            if (e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)e.getSource().func_76346_g();
                attacker.func_70690_d(new PotionEffect(MobEffects.field_82731_v, armorCount * 20, armorCount > 2 ? 1 : 0));
            }
            if (e.getSource().func_94541_c()) {
                e.setAmount(e.getAmount() * (1.0f - (float)armorCount / 8.0f));
            }
            return true;
        }
        return false;
    }

    private boolean obsidianArmor(LivingHurtEvent e) {
        EntityLivingBase hurt = e.getEntityLiving();
        int armorCount = ArmorHandler.getWearingSetCount(hurt, ItemArmorObsidian.class);
        if (armorCount > 0) {
            if (e.getSource().func_94541_c()) {
                e.setAmount(e.getAmount() * (1.0f - (float)armorCount / 4.0f));
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void resetStatus(LivingEvent.LivingUpdateEvent e) {
        IAttributeInstance inst;
        EntityLivingBase guy = e.getEntityLiving();
        if (!guy.field_70170_p.field_72995_K && (inst = guy.func_110148_a(SharedMonsterAttributes.field_111266_c)).func_111127_a(knockbackID) != null) {
            inst.func_188479_b(knockbackID);
        }
    }

    public static int getWearingSetCount(EntityLivingBase entity, Class<? extends ItemArmor> armorClass) {
        ItemStack HEAD = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack CHEST = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack LEGS = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack FEET = entity.func_184582_a(EntityEquipmentSlot.FEET);
        boolean helm = !HEAD.func_190926_b() && armorClass.isInstance(HEAD.func_77973_b());
        boolean chest = !CHEST.func_190926_b() && armorClass.isInstance(CHEST.func_77973_b());
        boolean legs = !LEGS.func_190926_b() && armorClass.isInstance(LEGS.func_77973_b());
        boolean boots = !FEET.func_190926_b() && armorClass.isInstance(FEET.func_77973_b());
        return (helm ? 1 : 0) + (chest ? 1 : 0) + (legs ? 1 : 0) + (boots ? 1 : 0);
    }
}

