/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.init;

import com.advancedcombat.api.IItemAdvanced;
import com.advancedcombat.api.ISwordAdvanced;
import com.advancedcombat.config.ACConfig;
import com.advancedcombat.init.ACBlocks;
import com.advancedcombat.registry.RegistryHelper;
import com.advancedcombat.swords.SwordBasic;
import com.advancedcombat.swords.SwordCreative;
import com.advancedcombat.swords.SwordCustomRepair;
import com.advancedcombat.swords.SwordShiny;
import com.advancedcombat.util.JointList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Swords {
    private static JointList<ISwordAdvanced> swords;
    public static SwordCustomRepair advancedWoodenSword;
    public static SwordBasic advancedStoneSword;
    public static SwordBasic advancedIronSword;
    public static SwordBasic advancedGoldenSword;
    public static SwordBasic advancedEmeraldSword;
    public static SwordBasic advancedDiamondSword;
    public static SwordBasic netherStarSword;
    public static SwordBasic advancedNetherStarSword;
    public static SwordBasic creativeSword;
    public static Item.ToolMaterial advancedWood;
    public static Item.ToolMaterial advancedStone;
    public static Item.ToolMaterial advancedIron;
    public static Item.ToolMaterial advancedGold;
    public static Item.ToolMaterial advancedEmerald;
    public static Item.ToolMaterial advancedDiamond;
    public static Item.ToolMaterial netherStar;
    public static Item.ToolMaterial advancedNetherStar;
    public static Item.ToolMaterial creative;

    public static void mainRegistry() {
        swords = new JointList();
        Swords.setupMaterials();
        Swords.addSwords();
        Swords.registerSwords();
    }

    public static List<ISwordAdvanced> getRegisteredSwords() {
        return swords;
    }

    private static void setupMaterials() {
        advancedWood = EnumHelper.addToolMaterial((String)"advancedWood", (int)1, (int)236, (float)8.0f, (float)1.75f, (int)8);
        advancedStone = EnumHelper.addToolMaterial((String)"advancedStone", (int)2, (int)524, (float)12.0f, (float)3.0f, (int)3);
        advancedStone.setRepairItem(new ItemStack((Block)ACBlocks.advancedStone));
        advancedIron = EnumHelper.addToolMaterial((String)"advancedIron", (int)3, (int)2250, (float)18.0f, (float)10.0f, (int)7);
        advancedIron.setRepairItem(new ItemStack(Blocks.field_150339_S));
        advancedGold = EnumHelper.addToolMaterial((String)"advancedGold", (int)2, (int)1561, (float)8.0f, (float)6.0f, (int)15);
        advancedGold.setRepairItem(new ItemStack(Blocks.field_150340_R));
        advancedEmerald = EnumHelper.addToolMaterial((String)"advancedEmerald", (int)4, (int)3122, (float)12.0f, (float)(ACConfig.emeraldSwordDamage - 4), (int)22);
        advancedEmerald.setRepairItem(new ItemStack(Blocks.field_150475_bE));
        advancedDiamond = EnumHelper.addToolMaterial((String)"advancedDiamond", (int)4, (int)8192, (float)24.0f, (float)20.0f, (int)5);
        advancedDiamond.setRepairItem(new ItemStack(Blocks.field_150484_ah));
        netherStar = EnumHelper.addToolMaterial((String)"netherStar", (int)4, (int)9366, (float)20.0f, (float)26.0f, (int)1);
        netherStar.setRepairItem(new ItemStack(Items.field_151156_bN));
        advancedNetherStar = EnumHelper.addToolMaterial((String)"advancedNetherStar", (int)5, (int)16384, (float)30.0f, (float)56.0f, (int)0);
        advancedNetherStar.setRepairItem(new ItemStack((Block)ACBlocks.netherStarBlock));
        creative = EnumHelper.addToolMaterial((String)"creative_", (int)1000, (int)1, (float)0.0f, (float)0.0f, (int)0);
    }

    private static void addSwords() {
        ISwordAdvanced[] iSwordAdvancedArray = new ISwordAdvanced[9];
        advancedWoodenSword = (SwordCustomRepair)new SwordCustomRepair(advancedWood).setRegistryName("advanced_wooden_sword");
        iSwordAdvancedArray[0] = advancedWoodenSword;
        advancedStoneSword = (SwordBasic)new SwordBasic(advancedStone).setRegistryName("advanced_stone_sword");
        iSwordAdvancedArray[1] = advancedStoneSword;
        advancedIronSword = (SwordBasic)new SwordBasic(advancedIron).setRegistryName("advanced_iron_sword");
        iSwordAdvancedArray[2] = advancedIronSword;
        advancedGoldenSword = (SwordBasic)new SwordBasic(advancedGold).setRegistryName("advanced_golden_sword");
        iSwordAdvancedArray[3] = advancedGoldenSword;
        advancedEmeraldSword = (SwordBasic)new SwordBasic(advancedEmerald).setRegistryName("advanced_emerald_sword");
        iSwordAdvancedArray[4] = advancedEmeraldSword;
        advancedDiamondSword = (SwordBasic)new SwordBasic(advancedDiamond).setRegistryName("advanced_diamond_sword");
        iSwordAdvancedArray[5] = advancedDiamondSword;
        netherStarSword = (SwordBasic)new SwordShiny(netherStar).setRegistryName("nether_star_sword");
        iSwordAdvancedArray[6] = netherStarSword;
        advancedNetherStarSword = (SwordBasic)new SwordShiny(advancedNetherStar).setRegistryName("advanced_nether_star_sword");
        iSwordAdvancedArray[7] = advancedNetherStarSword;
        creativeSword = (SwordBasic)new SwordCreative(creative).setRegistryName("creative_sword");
        iSwordAdvancedArray[8] = creativeSword;
        swords.join((ISwordAdvanced[])iSwordAdvancedArray);
        if (!ACConfig.enableCreativeSword) {
            swords.remove(creativeSword);
        }
    }

    private static void registerSwords() {
        JointList<IItemAdvanced> items = new JointList<ISwordAdvanced>().join((Iterable<ISwordAdvanced>)swords);
        RegistryHelper.registerItems(items);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRendering() {
        for (ISwordAdvanced sword : swords) {
            sword.registerRender();
        }
    }

    public static void finalizeSwords() {
        advancedWoodenSword.addRepairOres("logWood");
    }
}

