/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.integration.jei;

import com.advancedcombat.integration.jei.EnchantmentUpgradeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.util.ResourceLocation;

public class EnchantmentUpgradeCategory
extends BlankRecipeCategory {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final String UID = "advancedcombat:enchantment_upgrade_category";
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final ICraftingGridHelper craftingGridHelper;

    public EnchantmentUpgradeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/crafting_table.png");
        this.background = guiHelper.createDrawable(location, 29, 16, 116, 54);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return "Enchantment Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (recipeWrapper instanceof EnchantmentUpgradeWrapper) {
            guiItemStacks.set(ingredients);
        }
    }

    public String getModName() {
        return "Advanced Combat";
    }
}

