/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.integration.jei;

import com.advancedcombat.crafting.RecipeEnchantmentUpgrade;
import com.advancedcombat.util.ACUtils;
import com.advancedcombat.util.JointList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeEnchantmentUpgradeJEI {
    private static List<RecipeEnchantmentUpgradeJEI> allRecipes = new JointList<RecipeEnchantmentUpgradeJEI>();
    protected final ItemStack item;
    protected final ItemStack upgrade;
    protected final ItemStack output;

    public RecipeEnchantmentUpgradeJEI(ItemStack sword, ItemStack upgrade, ItemStack output) {
        this.item = sword;
        this.upgrade = upgrade;
        this.output = output;
    }

    public static List<RecipeEnchantmentUpgradeJEI> getRecipeList() {
        if (allRecipes.isEmpty()) {
            for (RecipeEnchantmentUpgrade u : RecipeEnchantmentUpgrade.getAllUpgrades()) {
                JointList<ItemStack> enchIn = RecipeEnchantmentUpgradeJEI.getEnchantedItems(ACUtils.getAllEnchantables(u), u, 0);
                ItemStack upgrade = u.getUpgrade();
                JointList<ItemStack> enchOut = RecipeEnchantmentUpgradeJEI.getEnchantedItems(ACUtils.getAllEnchantables(u), u, 1);
                for (int i = 0; i < enchIn.size(); ++i) {
                    allRecipes.add(new RecipeEnchantmentUpgradeJEI((ItemStack)enchIn.get(i), upgrade, (ItemStack)enchOut.get(i)));
                }
            }
        }
        return allRecipes;
    }

    public static JointList<ItemStack> getEnchantedItems(List<ItemStack> allOfType, RecipeEnchantmentUpgrade recipe, int step) {
        JointList<ItemStack> enchantedItems = new JointList<ItemStack>();
        for (ItemStack currentItem : allOfType) {
            for (int level = recipe.getMinLevelToApply() + step; level < recipe.getMaxUpgradeLevel() + step; ++level) {
                ItemStack stack = currentItem.func_77946_l();
                if (level > 0) {
                    stack.func_77966_a(recipe.getEnchantment(), level);
                }
                enchantedItems.add(stack);
            }
        }
        return enchantedItems;
    }
}

