/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.registry;

import com.advancedcombat.AdvancedCombat;
import com.advancedcombat.api.IBlockAdvanced;
import com.advancedcombat.api.IItemAdvanced;
import com.advancedcombat.crafting.ACCraftingManager;
import com.advancedcombat.init.ACBlocks;
import com.advancedcombat.init.ACItems;
import com.advancedcombat.ref.Log;
import com.advancedcombat.util.JointList;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static final List<IRecipe> RECIPES_TO_REGISTER = new JointList<IRecipe>();
    public static final List<Block> BLOCKS_TO_REGISTER = new JointList<Block>();
    public static final List<Item> ITEMS_TO_REGISTER = new JointList<Item>();

    public static void registerBlocks(Iterable<IBlockAdvanced> regBlocks) {
        for (IBlockAdvanced r : regBlocks) {
            RegistryHelper.registerBlock(r);
        }
    }

    public static void registerItems(Iterable<IItemAdvanced> regItems) {
        for (IItemAdvanced r : regItems) {
            RegistryHelper.registerItem(r);
        }
    }

    public static void registerBlock(IBlockAdvanced regBlock) {
        Block block = (Block)regBlock;
        BLOCKS_TO_REGISTER.add(block.func_149663_c(block.getRegistryName().toString()));
        if (regBlock.getItemClass() != null) {
            ItemBlock item;
            try {
                Class[] ctorArgClasses = new Class[regBlock.getItemClassArgs().length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = regBlock.getItemClassArgs()[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = regBlock.getItemClass().getConstructor(ctorArgClasses);
                item = itemCtor.newInstance(ObjectArrays.concat((Object)regBlock, (Object[])regBlock.getItemClassArgs()));
            }
            catch (Exception e) {
                Log.logger.error("Unable to register block " + block.getRegistryName());
                return;
            }
            ITEMS_TO_REGISTER.add((Item)item.setRegistryName(block.getRegistryName()));
        }
    }

    public static void registerItem(IItemAdvanced regItem) {
        Item item = (Item)regItem;
        ITEMS_TO_REGISTER.add(item.func_77655_b(item.getRegistryName().toString()));
    }

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> e) {
        ACBlocks.mainRegistry();
        for (Block b : BLOCKS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)b);
        }
        BLOCKS_TO_REGISTER.clear();
        Log.logger.info("Blocks registered.");
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> e) {
        ACItems.mainRegistry();
        for (Item i : ITEMS_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)i);
        }
        ITEMS_TO_REGISTER.clear();
        ACCraftingManager.addOreDictEntries();
        AdvancedCombat.proxy.registerModels();
        Log.logger.info("Items registered.");
    }

    @SubscribeEvent
    public void onRecipeRegistry(RegistryEvent.Register<IRecipe> e) {
        ACCraftingManager.addCraftingRecipes();
        for (IRecipe r : RECIPES_TO_REGISTER) {
            e.getRegistry().register((IForgeRegistryEntry)r);
        }
        RECIPES_TO_REGISTER.clear();
        Log.logger.info("Recipes registered.");
    }
}

